/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf.model;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hawk.core.IFileImporter;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.eclipse.hawk.emf.model.EMFModelResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFModelResourceFactory
implements IModelResourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFModelResourceFactory.class);
    public static final String PROPERTY_EXTRA_EXTENSIONS = "org.eclipse.hawk.emf.model.extraExtensions";
    private static final String TYPE = "org.eclipse.hawk.emf.metamodel.EMFModelParser";
    private static final String HUMAN_READABLE_NAME = "EMF Model Resource Factory";
    private Set<String> modelExtensions = new HashSet<String>();

    public EMFModelResourceFactory() {
        for (String ext : Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().keySet()) {
            if ("*".equals(ext)) continue;
            this.modelExtensions.add("." + ext);
        }
        this.modelExtensions.add(".xmi");
        this.modelExtensions.add(".model");
        String sExtraExtensions = System.getProperty(PROPERTY_EXTRA_EXTENSIONS);
        if (sExtraExtensions != null) {
            String[] extraExtensions;
            String[] stringArray = extraExtensions = sExtraExtensions.split(",");
            int n = extraExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extraExtension = stringArray[n2];
                this.modelExtensions.add(extraExtension);
                ++n2;
            }
        }
    }

    public final String getType() {
        return TYPE;
    }

    public String getHumanReadableName() {
        return HUMAN_READABLE_NAME;
    }

    public EMFModelResource parse(IFileImporter importer, File f) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)f.getCanonicalPath());
            Resource.Factory factory = this.createResourceFactory((ResourceSet)resourceSet, fileURI);
            Resource r = factory.createResource(fileURI);
            resourceSet.getResources().add((Object)r);
            r.load(this.createEMFLoadOptions());
            return new EMFModelResource(r, new EMFWrapperFactory(), this);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + f.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    public void shutdown() {
    }

    public Set<String> getModelExtensions() {
        return this.modelExtensions;
    }

    protected Resource.Factory createResourceFactory(ResourceSet resourceSet, URI fileURI) {
        Resource.Factory factory = resourceSet.getResourceFactoryRegistry().getFactory(fileURI);
        if (factory == null) {
            return new XMIResourceFactoryImpl();
        }
        return factory;
    }

    protected Map<?, ?> createEMFLoadOptions() {
        return Collections.emptyMap();
    }

    public boolean canParse(File f) {
        String[] split = f.getPath().split("\\.");
        String extension = split[split.length - 1];
        return this.getModelExtensions().contains("." + extension);
    }
}

