/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.runtime;

import java.util.LinkedHashSet;
import org.eclipse.hawk.core.IStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeStateListener
extends LinkedHashSet<IStateListener>
implements IStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeStateListener.class);
    private static final long serialVersionUID = 6358455874909268099L;
    private IStateListener.HawkState currentState = IStateListener.HawkState.STOPPED;

    @Override
    public boolean add(IStateListener e) {
        boolean ret = super.add(e);
        e.state(this.currentState);
        return ret;
    }

    @Override
    public boolean remove(Object e) {
        boolean ret = super.remove(e);
        if (ret) {
            ((IStateListener)e).removed();
        }
        return ret;
    }

    @Override
    public void removed() {
    }

    @Override
    public void info(String s) {
        for (IStateListener l : this) {
            l.info(s);
        }
        LOGGER.info(s);
    }

    @Override
    public void error(String s) {
        for (IStateListener l : this) {
            l.error(s);
        }
        LOGGER.error(s);
    }

    @Override
    public synchronized void state(IStateListener.HawkState state) {
        this.currentState = state;
        for (IStateListener l : this) {
            l.state(state);
        }
        this.notifyAll();
    }

    public IStateListener.HawkState getCurrentState() {
        return this.currentState;
    }
}

