/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.emf.EMFModelElement;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFFeatureMapReference
extends EMFModelElement
implements IHawkReference {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFFeatureMapReference.class);
    private EAttribute r;

    public EMFFeatureMapReference(EAttribute esf, EMFWrapperFactory wf) {
        super((EModelElement)esf, wf);
        this.r = esf;
    }

    public String getName() {
        return this.r.getName();
    }

    public EAttribute getEObject() {
        return this.r;
    }

    public boolean isContainment() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isMany() {
        return true;
    }

    public boolean isOrdered() {
        return true;
    }

    public boolean isUnique() {
        return false;
    }

    @Override
    public IHawkClassifier getType() {
        EClassifier type = this.r.getEType();
        if (type instanceof EClass) {
            return this.wf.createClass((EClass)this.r.getEType());
        }
        if (type instanceof EDataType) {
            return this.wf.createDataType((EDataType)this.r.getEType());
        }
        LOGGER.warn("Unknown EClassifier subclass: {}", (Object)this.r.getEType());
        return null;
    }

    @Override
    public int hashCode() {
        return this.r.hashCode();
    }
}

