/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkDataType;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelioObject
implements IHawkObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractModelioObject.class);
    byte[] signature = null;

    public abstract String getExml();

    public boolean isInDifferentResourceThan(IHawkObject other) {
        if (other instanceof AbstractModelioObject) {
            String otherExml = ((AbstractModelioObject)other).getExml();
            return !this.getExml().equals(otherExml);
        }
        return false;
    }

    public boolean URIIsRelative() {
        return false;
    }

    public byte[] signature() {
        if (this.signature == null) {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println("signature() tried to create a SHA-1 digest but a NoSuchAlgorithmException was thrown, returning null");
                return null;
            }
            md.update(this.getUri().getBytes());
            md.update(this.getUriFragment().getBytes());
            IHawkClassifier type = this.getType();
            md.update(type.getName().getBytes());
            md.update(type.getPackageNSURI().getBytes());
            if (!(type instanceof IHawkDataType)) {
                if (type instanceof IHawkClass) {
                    for (IHawkAttribute eAttribute : ((IHawkClass)type).getAllAttributes()) {
                        if (!eAttribute.isDerived() && !this.isSet((IHawkStructuralFeature)eAttribute)) continue;
                        md.update(eAttribute.getName().getBytes());
                        if (eAttribute.isDerived()) continue;
                        md.update(this.get(eAttribute).toString().getBytes());
                    }
                    for (IHawkReference eRef : ((IHawkClass)type).getAllReferences()) {
                        if (!this.isSet((IHawkStructuralFeature)eRef)) continue;
                        md.update(eRef.getName().getBytes());
                        Object destinationObjects = this.get(eRef, false);
                        if (destinationObjects instanceof Iterable) {
                            for (IHawkObject o : (Iterable)destinationObjects) {
                                md.update(o.getUriFragment().getBytes());
                            }
                            continue;
                        }
                        if (destinationObjects != null) {
                            md.update(((IHawkObject)destinationObjects).getUriFragment().getBytes());
                            continue;
                        }
                        LOGGER.warn("Destination object for feature {} of {} is null", (Object)eRef.getName(), (Object)this);
                    }
                } else {
                    System.err.println("warning emf object tried to create signature, but found type: " + type);
                }
            }
            this.signature = md.digest();
        }
        return this.signature;
    }
}

