/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.osgiserver;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawk;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IMetaModelIntrospector;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IMetaModelUpdater;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.util.FallbackFrozenVcsManager;
import org.eclipse.hawk.core.util.HawkConfig;
import org.eclipse.hawk.core.util.HawkProperties;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.core.util.SLF4JConsole;
import org.eclipse.hawk.core.util.XStreamUtils;
import org.eclipse.hawk.osgiserver.HManager;
import org.osgi.service.prefs.BackingStoreException;

public class HModel
implements IStateListener {
    public static String DEFAULT_INFO = "Sleeping...";
    private String info = DEFAULT_INFO;
    private IStateListener.HawkState status;
    private static IConsole CONSOLE = new SLF4JConsole();
    private List<String> enabledPlugins;
    private final IHawk hawk;
    private final IHawkFactory hawkFactory;
    private final HManager manager;
    private final String hawkLocation;

    protected void setStatus(IStateListener.HawkState status) {
        if (this.status != status) {
            this.status = status;
            this.manager.stateChanged(this);
        }
    }

    public IStateListener.HawkState getStatus() {
        return this.status;
    }

    public void setInfo(String info) {
        if (!this.info.equals(info)) {
            this.info = info;
            this.manager.infoChanged(this);
        }
    }

    public String getInfo() {
        return this.info;
    }

    public static IConsole getConsole() {
        if (CONSOLE == null) {
            CONSOLE = new SLF4JConsole();
        }
        return CONSOLE;
    }

    public static void setConsole(IConsole c) {
        CONSOLE = c;
    }

    public static HModel create(IHawkFactory hawkFactory, String name, File storageFolder, String location, String dbType, List<String> plugins, HManager manager, ICredentialsStore credStore, int minDelay, int maxDelay) throws Exception {
        if (minDelay > maxDelay) {
            throw new IllegalArgumentException("minimum delay must be less than or equal to maximum delay");
        }
        if (minDelay < 0) {
            throw new IllegalArgumentException("minimum delay must not be negative");
        }
        if (maxDelay < 0) {
            throw new IllegalArgumentException("maximum delay must not be negative");
        }
        HModel hm = new HModel(manager, hawkFactory, name, storageFolder, location, credStore, plugins);
        if (dbType != null) {
            hm.hawk.setDatabaseType(dbType);
        }
        if (hm.getModelUpdaters() != null && hm.getModelUpdaters().isEmpty()) {
            throw new IllegalArgumentException("Must add at least one updater");
        }
        IGraphDatabase db = null;
        IConsole console = HModel.getConsole();
        try {
            console.println("Creating Hawk indexer...");
            if (hawkFactory.instancesCreateGraph()) {
                console.println("Setting up hawk's back-end store:");
                db = manager.createBackendGraph(hm.hawk);
                db.run(storageFolder, console);
                hm.hawk.getModelIndexer().setDB(db, true);
            }
            IMetaModelUpdater metaModelUpdater = manager.getMetaModelUpdater();
            console.println("Setting up hawk's metamodel updater:\n" + metaModelUpdater.getType());
            hm.hawk.getModelIndexer().setMetaModelUpdater(metaModelUpdater);
            hm.hawk.getModelIndexer().init(minDelay, maxDelay);
            manager.addHawk(hm);
            manager.saveHawkToMetadata(hm);
            console.println("Created Hawk indexer!");
            return hm;
        }
        catch (Exception e) {
            console.printerrln("Adding of indexer aborted, please try again.\nShutting down and removing back-end (if it was created)");
            console.printerrln((Throwable)e);
            if (db != null) {
                db.delete();
            }
            console.printerrln("aborting finished.");
            throw e;
        }
    }

    public static HModel load(HawkConfig config, HManager manager) throws Exception {
        IHawkFactory hawkFactory = manager.createHawkFactory(config.getHawkFactory());
        HModel hm = new HModel(manager, hawkFactory, config.getName(), new File(config.getStorageFolder()), config.getLocation(), manager.getCredentialsStore(), config.getEnabledPlugins());
        IMetaModelUpdater metaModelUpdater = manager.getMetaModelUpdater();
        hm.hawk.getModelIndexer().setMetaModelUpdater(metaModelUpdater);
        return hm;
    }

    public boolean isLocal() {
        return this.hawk.getModelIndexer().getGraph() != null;
    }

    public IHawk getHawk() {
        return this.hawk;
    }

    public String getDbType() {
        return this.hawk.getDatabaseType();
    }

    public void setDbType(String dbType) throws Exception {
        this.hawk.setDatabaseType(dbType);
        if (this.hawkFactory.instancesCreateGraph()) {
            IGraphDatabase db = this.manager.createBackendGraph(this.hawk);
            db.run(new File(this.getHawkConfig().getStorageFolder()), HModel.getConsole());
            this.hawk.getModelIndexer().setDB(db, true);
        }
    }

    public HModel(HManager manager, IHawkFactory hawkFactory, String name, File storageFolder, String location, ICredentialsStore credStore, List<String> plugins) throws Exception {
        this.hawkFactory = hawkFactory;
        this.hawk = hawkFactory.create(name, storageFolder, location, credStore, HModel.getConsole(), plugins);
        this.manager = manager;
        this.hawkLocation = location;
        this.enabledPlugins = plugins;
        this.enablePlugins();
        this.hawk.getModelIndexer().addStateListener((IStateListener)this);
    }

    public void addPlugins(Collection<String> plugins) throws Exception {
        if (this.enabledPlugins == null) {
            this.enabledPlugins = new ArrayList<String>(plugins);
        } else if (!this.enabledPlugins.isEmpty()) {
            this.enabledPlugins.addAll(plugins);
        }
        this.enablePlugins();
    }

    public void removePlugins(Collection<String> plugins) throws Exception {
        if (this.enabledPlugins != null && !this.enabledPlugins.isEmpty()) {
            this.enabledPlugins.removeAll(plugins);
            this.disablePlugins(plugins);
        }
    }

    private void enablePlugins() throws Exception {
        if (!this.hawkFactory.instancesAreExtensible()) {
            return;
        }
        IConsole console = HModel.getConsole();
        IModelIndexer indexer = this.hawk.getModelIndexer();
        console.println("adding metamodel resource factories:");
        this.enablePlugins(this.manager.getMmps(), "MetaModelParser", IMetaModelResourceFactory.class, arg_0 -> ((IModelIndexer)indexer).addMetaModelResourceFactory(arg_0));
        console.println("adding model resource factories:");
        this.enablePlugins(this.manager.getMps(), "ModelParser", IModelResourceFactory.class, arg_0 -> ((IModelIndexer)indexer).addModelResourceFactory(arg_0));
        console.println("adding query engines:");
        this.enablePlugins(this.manager.getLanguages(), "query_language", IQueryEngine.class, arg_0 -> ((IModelIndexer)indexer).addQueryEngine(arg_0));
        console.println("adding model updaters:");
        this.enablePlugins(this.manager.getUps(), "ModelUpdater", IModelUpdater.class, arg_0 -> ((IModelIndexer)indexer).addModelUpdater(arg_0));
        console.println("adding graph change listeners:");
        this.enablePlugins(this.manager.getGraphChangeListeners(), "class", IGraphChangeListener.class, arg_0 -> ((IModelIndexer)indexer).addGraphChangeListener(arg_0));
    }

    private <T extends IHawkPlugin> void enablePlugins(List<IConfigurationElement> elems, String attribute, Class<T> klass, Consumer<T> addMethod) throws CoreException {
        IConsole console = HModel.getConsole();
        for (IConfigurationElement elem : elems) {
            IHawkPlugin f = (IHawkPlugin)elem.createExecutableExtension(attribute);
            if (this.enabledPlugins != null && !this.enabledPlugins.contains(f.getType())) continue;
            addMethod.accept(f);
            console.println(f.getHumanReadableName());
        }
    }

    private void disablePlugins(Collection<String> plugins) throws Exception {
        if (this.hawkFactory.instancesAreExtensible() && plugins != null) {
            IConsole console = HModel.getConsole();
            console.println("removing metamodel resource factories:");
            IModelIndexer indexer = this.hawk.getModelIndexer();
            this.disablePlugins(plugins, IMetaModelResourceFactory.class, indexer.getMetaModelParsers(), arg_0 -> ((IModelIndexer)indexer).removeMetaModelResourceFactory(arg_0));
            console.println("removing model resource factories:");
            this.disablePlugins(plugins, IModelResourceFactory.class, indexer.getModelParsers(), arg_0 -> ((IModelIndexer)indexer).removeModelResourceFactory(arg_0));
            console.println("removing model updaters:");
            this.disablePlugins(plugins, IModelUpdater.class, this.hawk.getModelIndexer().getModelUpdaters(), arg_0 -> ((IModelIndexer)indexer).removeModelUpdater(arg_0));
            console.println("removing graph change listeners:");
            this.disablePlugins(plugins, (Class)IGraphChangeListener.class, (Collection)indexer.getCompositeGraphChangeListener(), arg_0 -> ((IModelIndexer)this.hawk.getModelIndexer()).removeGraphChangeListener(arg_0));
        }
    }

    private <T extends IHawkPlugin> void disablePlugins(Collection<String> pluginTypesToRemove, Class<T> klass, Collection<T> plugins, FlakyConsumer<T> remover) throws Exception {
        for (IHawkPlugin t : new ArrayList<T>(plugins)) {
            if (!pluginTypesToRemove.contains(t.getType())) continue;
            remover.accept(t);
        }
    }

    public void addDerivedAttribute(String metamodeluri, String typename, String attributename, String attributetype, Boolean isMany, Boolean isOrdered, Boolean isUnique, String derivationlanguage, String derivationlogic) throws Exception {
        this.hawk.getModelIndexer().addDerivedAttribute(metamodeluri, typename, attributename, attributetype, isMany.booleanValue(), isOrdered.booleanValue(), isUnique.booleanValue(), derivationlanguage, derivationlogic);
    }

    private void loadVCS(String loc, String type, boolean isFrozen) throws Exception {
        IVcsManager mo;
        IModelIndexer indexer = this.hawk.getModelIndexer();
        try {
            mo = this.manager.createVCSManager(type);
        }
        catch (Exception ex) {
            HModel.getConsole().printerrln((Throwable)ex);
            HModel.getConsole().printerrln("Falling back to frozen VCS");
            mo = new FallbackFrozenVcsManager();
        }
        mo.init(loc, indexer);
        if (!this.getLocations().contains(mo.getLocation())) {
            mo.run();
            mo.setFrozen(isFrozen);
            indexer.addVCSManager(mo, false);
        }
    }

    public void addIndexedAttribute(String metamodeluri, String typename, String attributename) throws Exception {
        this.hawk.getModelIndexer().addIndexedAttribute(metamodeluri, typename, attributename);
    }

    public void addVCS(String loc, String type, String user, String pass, boolean isFrozen) {
        try {
            IVcsManager mo = this.manager.createVCSManager(type);
            mo.init(loc, this.hawk.getModelIndexer());
            if (!this.getLocations().contains(mo.getLocation())) {
                if (mo.isAuthSupported()) {
                    mo.setCredentials(user, pass, this.hawk.getModelIndexer().getCredentialsStore());
                }
                mo.run();
                mo.setFrozen(isFrozen);
                this.hawk.getModelIndexer().addVCSManager(mo, true);
            }
        }
        catch (Exception e) {
            HModel.getConsole().printerrln((Throwable)e);
        }
    }

    public boolean addGraphChangeListener(IGraphChangeListener changeListener) {
        return this.hawk.getModelIndexer().addGraphChangeListener(changeListener);
    }

    public boolean removeGraphChangeListener(IGraphChangeListener changeListener) {
        return this.hawk.getModelIndexer().removeGraphChangeListener(changeListener);
    }

    public Object query(File query, String ql, Map<String, Object> context) throws Exception {
        IQueryEngine q = (IQueryEngine)this.hawk.getModelIndexer().getKnownQueryLanguages().get(ql);
        if (q == null) {
            throw new NoSuchElementException();
        }
        return q.query(this.hawk.getModelIndexer(), query, context);
    }

    public Object query(String query, String ql, Map<String, Object> context) throws Exception {
        IQueryEngine q = (IQueryEngine)this.hawk.getModelIndexer().getKnownQueryLanguages().get(ql);
        if (q == null) {
            throw new NoSuchElementException();
        }
        return q.query(this.hawk.getModelIndexer(), query, context);
    }

    public void delete() throws BackingStoreException {
        this.manager.removeHawkFromMetadata(this.getHawkConfig());
        File f = this.hawk.getModelIndexer().getParentFolder();
        if (this.isRunning()) {
            try {
                this.hawk.getModelIndexer().shutdown(IModelIndexer.ShutdownRequestType.ONLY_LOCAL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (f.exists()) {
            HModel.getConsole().println("Hawk instance removed from ui but persistence remains at: " + f);
        }
    }

    public HawkConfig getHawkConfig() {
        return new HawkConfig(this.getName(), this.getFolder(), this.hawkLocation, this.hawkFactory.getClass().getName(), this.enabledPlugins);
    }

    public boolean exists() {
        return this.hawk != null && this.hawk.exists();
    }

    public List<String> getEnabledPlugins() {
        return this.enabledPlugins;
    }

    public Collection<IMetaModelResourceFactory> getMetamodelParsers() {
        ArrayList<IMetaModelResourceFactory> parsers = new ArrayList<IMetaModelResourceFactory>();
        for (String type : this.hawk.getModelIndexer().getKnownMetaModelParserTypes()) {
            IMetaModelResourceFactory parser = this.hawk.getModelIndexer().getMetaModelParser(type);
            parsers.add(parser);
        }
        return parsers;
    }

    public Collection<IndexedAttributeParameters> getDerivedAttributes() {
        return this.hawk.getModelIndexer().getDerivedAttributes();
    }

    public String getFolder() {
        return this.hawk.getModelIndexer().getParentFolder().toString();
    }

    public IGraphDatabase getGraph() {
        return this.hawk.getModelIndexer().getGraph();
    }

    public IMetaModelIntrospector getIntrospector() {
        return this.manager.getIntrospectorFor(this.hawk.getModelIndexer());
    }

    public Collection<IndexedAttributeParameters> getIndexedAttributes() {
        return this.hawk.getModelIndexer().getIndexedAttributes();
    }

    public Collection<IModelUpdater> getModelUpdaters() {
        return this.hawk.getModelIndexer().getModelUpdaters();
    }

    public Collection<String> getIndexes() {
        return this.hawk.getModelIndexer().getIndexes();
    }

    public Set<String> getKnownQueryLanguages() {
        return this.hawk.getModelIndexer().getKnownQueryLanguages().keySet();
    }

    public Collection<String> getLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        for (IVcsManager o : this.getRunningVCSManagers()) {
            locations.add(o.getLocation());
        }
        return locations;
    }

    public Collection<IVcsManager> getRunningVCSManagers() {
        return this.hawk.getModelIndexer().getRunningVCSManagers();
    }

    public String getName() {
        return this.hawk.getModelIndexer().getName();
    }

    public List<String> getRegisteredMetamodels() {
        return new ArrayList<String>(this.hawk.getModelIndexer().getKnownMMUris());
    }

    public List<IVcsManager> getVCSInstances() {
        return this.manager.getVCSInstances();
    }

    public boolean isRunning() {
        return this.hawk.getModelIndexer().isRunning();
    }

    public HManager getManager() {
        return this.manager;
    }

    public void registerMeta(File ... f) throws Exception {
        this.hawk.getModelIndexer().registerMetamodels(f);
    }

    public boolean start(HManager manager) {
        try {
            HawkProperties hp = this.loadIndexerMetadata();
            if (this.hawkFactory.instancesCreateGraph()) {
                IGraphDatabase db = manager.createBackendGraph(this.hawk);
                db.run(new File(this.getFolder()), HModel.getConsole());
                this.hawk.getModelIndexer().setDB(db, false);
            }
            this.hawk.getModelIndexer().init(hp.getMinDelay(), hp.getMaxDelay());
        }
        catch (Exception e) {
            HModel.getConsole().printerrln((Throwable)e);
        }
        boolean running = this.hawk.getModelIndexer().isRunning();
        return running;
    }

    public void stop(IModelIndexer.ShutdownRequestType requestType) {
        try {
            this.hawk.getModelIndexer().shutdown(requestType);
        }
        catch (Exception e) {
            HModel.getConsole().printerrln((Throwable)e);
        }
    }

    public void sync() throws Exception {
        this.hawk.getModelIndexer().requestImmediateSync();
    }

    public String toString() {
        String ret = "";
        try {
            ret = String.valueOf(this.getName()) + " [" + this.getFolder() + "] ";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public List<String> validateExpression(String derivationlanguage, String derivationlogic) {
        return this.hawk.getModelIndexer().validateExpression(derivationlanguage, derivationlogic);
    }

    private HawkProperties loadIndexerMetadata() throws Exception {
        XStream stream = XStreamUtils.createXStreamLoader((Class[])new Class[]{HawkProperties.class});
        String path = this.hawk.getModelIndexer().getParentFolder() + File.separator + "properties.xml";
        HawkProperties hp = (HawkProperties)stream.fromXML(new File(path));
        this.hawk.setDatabaseType(hp.getDbType());
        for (String[] s : hp.getMonitoredVCS()) {
            this.loadVCS(s[0], s[1], s.length > 2 ? Boolean.parseBoolean(s[2]) : false);
        }
        return hp;
    }

    public boolean removeDerivedAttribute(String metamodelUri, String typeName, String attributeName) {
        return this.hawk.getModelIndexer().removeDerivedAttribute(metamodelUri, typeName, attributeName);
    }

    public boolean removeIndexedAttribute(String metamodelUri, String typename, String attributename) {
        return this.hawk.getModelIndexer().removeIndexedAttribute(metamodelUri, typename, attributename);
    }

    public void removeRepository(IVcsManager manager) throws Exception {
        try {
            this.hawk.getModelIndexer().removeVCSManager(manager);
        }
        catch (Exception e) {
            HModel.getConsole().printerrln((Throwable)e);
        }
    }

    public IModelIndexer getIndexer() {
        return this.hawk.getModelIndexer();
    }

    public void configurePolling(int base, int max) {
        this.hawk.getModelIndexer().setPolling(base, max);
    }

    public void removeMetamodels(String[] selectedMetamodels) {
        try {
            this.hawk.getModelIndexer().removeMetamodels(selectedMetamodels);
        }
        catch (Exception e) {
            HModel.getConsole().printerrln((Throwable)e);
        }
    }

    public void state(IStateListener.HawkState state) {
        this.setStatus(state);
    }

    public void info(String s) {
        this.setInfo(s);
    }

    public void error(String s) {
        this.setInfo(s);
    }

    public void removed() {
    }

    public boolean removeIndexedAttributes(String[] selected) {
        boolean allSuccess = true;
        String[] stringArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Object[] ss = s.split("##");
            if (ss.length == 3) {
                allSuccess = allSuccess && this.removeIndexedAttribute(ss[0], (String)ss[1], (String)ss[2]);
            } else {
                this.setInfo("internal error in removeIndexedAttributes: " + Arrays.toString(ss));
                allSuccess = false;
            }
            ++n2;
        }
        return allSuccess;
    }

    public boolean removeDerivedAttributes(String[] selected) {
        boolean allSuccess = true;
        String[] stringArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Object[] ss = s.split("##");
            if (ss.length == 3) {
                allSuccess = allSuccess && this.removeDerivedAttribute(ss[0], (String)ss[1], (String)ss[2]);
            } else {
                this.setInfo("internal error in removeIndexedAttributes: " + Arrays.toString(ss));
                allSuccess = false;
            }
            ++n2;
        }
        return allSuccess;
    }

    @FunctionalInterface
    private static interface FlakyConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

