/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.graph;

import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.ModelElementNode;

public class DefaultTimeGraphWrapper
extends GraphWrapper {
    private final long timepoint;

    public DefaultTimeGraphWrapper(IGraphDatabase graph, long timepoint) {
        super(graph);
        this.timepoint = timepoint;
    }

    public Set<FileNode> getFileNodes(IGraphNodeIndex fileIndex, Iterable<String> repoPatterns, Iterable<String> filePatterns) {
        if (fileIndex instanceof ITimeAwareGraphNodeIndex) {
            ITimeAwareGraphNodeIndex taIndex = (ITimeAwareGraphNodeIndex)fileIndex;
            return super.getFileNodes((IGraphNodeIndex)taIndex.travelInTime(this.timepoint), repoPatterns, filePatterns);
        }
        return super.getFileNodes(fileIndex, repoPatterns, filePatterns);
    }

    public ModelElementNode getModelElementNodeById(Object id) {
        IGraphNode rawNode = this.graph.getNodeById(id);
        if (rawNode instanceof ITimeAwareGraphNode) {
            ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)rawNode;
            return new ModelElementNode((IGraphNode)taNode.travelInTime(this.timepoint));
        }
        if (rawNode == null) {
            throw new NoSuchElementException("No node exists with id " + id);
        }
        return new ModelElementNode(rawNode);
    }
}

