/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CrossOriginFilter
implements Filter {
    private static final String CUSTOM_ALLOW_ORIGIN = "hawk.http.allowOrigin";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            String customAllowOrigin = System.getProperty(CUSTOM_ALLOW_ORIGIN);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.addHeader("Access-Control-Allow-Origin", customAllowOrigin == null ? "*" : customAllowOrigin);
            httpResponse.addHeader("Access-Control-Allow-Headers", "Content-Type");
        }
        chain.doFilter(request, response);
    }
}

