/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;

public class Utils {
    protected String makeRelative(Set<String> bases, String extension) {
        for (String base : bases) {
            if (!extension.startsWith(base)) continue;
            return extension.substring(base.length());
        }
        return extension;
    }

    protected String[] addToElementProxies(String[] proxies, String fullPathURI, String edgelabel, boolean isContainment, boolean isContainer) {
        if (proxies != null) {
            String[] ret = new String[proxies.length + 4];
            int i = 0;
            while (i < proxies.length) {
                ret[i] = proxies[i];
                ret[i + 1] = proxies[i + 1];
                ret[i + 2] = proxies[i + 2];
                ret[i + 3] = proxies[i + 3];
                i += 4;
            }
            ret[proxies.length] = fullPathURI;
            ret[proxies.length + 1] = edgelabel;
            ret[proxies.length + 2] = String.valueOf(isContainment);
            ret[proxies.length + 3] = String.valueOf(isContainer);
            proxies = null;
            return ret;
        }
        String[] ret = new String[]{fullPathURI, edgelabel, String.valueOf(isContainment), String.valueOf(isContainer)};
        return ret;
    }

    public IGraphNode getFileNodeFromVCSCommitItem(IGraphDatabase graph, VcsCommitItem s) {
        String repository = s.getCommit().getDelta().getManager().getLocation();
        String filepath = s.getPath();
        String fullFileID = String.valueOf(repository) + "||||" + filepath;
        IGraphNode ret = null;
        IGraphTransaction t = null;
        try {
            if (graph.currentMode().equals((Object)IGraphDatabase.Mode.TX_MODE)) {
                t = graph.beginTransaction();
            }
            IGraphNodeIndex fi = graph.getFileIndex();
            fi.flush();
            Iterator itFile = fi.get("id", (Object)fullFileID).iterator();
            if (itFile.hasNext()) {
                ret = (IGraphNode)itFile.next();
            }
            if (graph.currentMode().equals((Object)IGraphDatabase.Mode.TX_MODE)) {
                t.success();
                t.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String[] removeFromElementProxies(String[] proxies, String fullPathURI, String edgelabel, boolean isContainment, boolean isContainer) {
        String[] result = null;
        int i = 0;
        while (i < proxies.length) {
            if (proxies[i].equals(fullPathURI) && proxies[i + 1].equals(edgelabel) && Boolean.valueOf(proxies[i + 2]) == isContainment && Boolean.valueOf(proxies[i + 3]) == isContainer) {
                result = new String[proxies.length - 4];
                System.arraycopy(proxies, 0, result, 0, i);
                System.arraycopy(proxies, i + 4, result, i, proxies.length - i - 4);
                break;
            }
            i += 4;
        }
        return result;
    }
}

