/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.register.MetamodelRegister;
import org.eclipse.hawk.modelio.exml.model.ModelioModelResourceFactory;
import org.eclipse.hawk.modelio.exml.model.ModelioObject;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlObject;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelioModelResource
implements IHawkModelResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelioModelResource.class);
    private Iterable<ExmlObject> exmls;
    private Set<IHawkObject> contents;
    private IModelResourceFactory parser;

    public ModelioModelResource(ExmlObject exml, IModelResourceFactory p) {
        this.parser = p;
        this.exmls = Collections.singletonList(exml);
    }

    public ModelioModelResource(Iterable<ExmlObject> objects, IModelResourceFactory p) {
        this.parser = p;
        this.exmls = objects;
    }

    public void unload() {
        this.exmls = null;
        this.contents = null;
    }

    public Iterable<IHawkObject> getAllContents() {
        return new Iterable<IHawkObject>(){

            @Override
            public Iterator<IHawkObject> iterator() {
                final Iterator itExmls = ModelioModelResource.this.exmls.iterator();
                final LinkedList currentFragment = new LinkedList();
                return new Iterator<IHawkObject>(){

                    @Override
                    public boolean hasNext() {
                        while (currentFragment.isEmpty() && itExmls.hasNext()) {
                            ExmlObject nextRoot = (ExmlObject)itExmls.next();
                            ModelioModelResource.this.addObjectToContents(nextRoot, currentFragment);
                        }
                        return !currentFragment.isEmpty();
                    }

                    @Override
                    public IHawkObject next() {
                        return (IHawkObject)currentFragment.remove(0);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Set<IHawkObject> getAllContentsSet() {
        if (this.contents == null) {
            this.contents = new HashSet<IHawkObject>();
            for (ExmlObject exml : this.exmls) {
                this.addObjectToContents(exml, this.contents);
            }
        }
        return this.contents;
    }

    private void addObjectToContents(ExmlObject exml, Collection<IHawkObject> contents) {
        Map<String, String> mmversions = ((ModelioModelResourceFactory)this.parser).getMmPackageVersions();
        ModelioClass mc = MetamodelRegister.INSTANCE.getModelioClass(exml.getMClassName(), mmversions);
        if (mc == null) {
            LOGGER.warn("Could not find class '{}', skipping", (Object)exml.getMClassName());
        } else {
            contents.add(new ModelioObject(mc, exml, mmversions));
            for (Map.Entry<String, List<ExmlReference>> composition : exml.getCompositions().entrySet()) {
                for (ExmlReference r : composition.getValue()) {
                    if (!(r instanceof ExmlObject)) continue;
                    ExmlObject exmlObject = (ExmlObject)r;
                    if (exmlObject.getParentUID() == null) {
                        exmlObject.setParentMClassName(exml.getMClassName());
                        exmlObject.setParentName(exml.getName());
                        exmlObject.setParentUID(exml.getUID());
                    }
                    this.addObjectToContents(exmlObject, contents);
                }
            }
        }
    }

    public boolean providesSingletonElements() {
        return true;
    }
}

