/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.gson.EObjectExclusionStrategy;
import org.eclipse.glsp.graph.gson.PropertyBasedTypeAdapter;

public class GModelElementTypeAdapter
extends PropertyBasedTypeAdapter<GModelElement> {
    protected static final Logger LOGGER = LogManager.getLogger(GModelElementTypeAdapter.class);
    private final Gson gson;
    private final Map<String, EClass> typeMap;
    private String delimiter = ":";

    public GModelElementTypeAdapter(Gson gson, String typeAttribute, Map<String, EClass> typeMap) {
        super(gson, typeAttribute);
        this.gson = gson;
        this.typeMap = typeMap;
    }

    @Override
    protected GModelElement createInstance(String type) {
        Optional<EClass> eClass = this.findEClassForType(type);
        if (eClass.isPresent()) {
            GModelElement element = (GModelElement)eClass.get().getEPackage().getEFactoryInstance().create(eClass.get());
            element.setType(type);
            return element;
        }
        LOGGER.error("Cannot find class for type " + type);
        return null;
    }

    protected Optional<EClass> findEClassForType(String type) {
        EClass eClass = this.typeMap.get(type);
        if (eClass == null) {
            ArrayList<String> subtypes = new ArrayList<String>(List.of(type.split(this.delimiter)));
            while (eClass == null && !subtypes.isEmpty()) {
                subtypes.remove(subtypes.size() - 1);
                eClass = this.typeMap.get(String.join((CharSequence)this.delimiter, subtypes));
            }
        }
        return Optional.ofNullable(eClass);
    }

    @Override
    public void write(JsonWriter out, GModelElement value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            try {
                out.beginObject();
                HashSet<String> written = new HashSet<String>();
                this.writeProperties(out, value, value.getClass(), (Set<String>)written);
                out.endObject();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void assignProperty(GModelElement instance, String propertyName, JsonReader in) throws IllegalAccessException {
        try {
            Field field = this.findField(instance.getClass(), propertyName);
            Object value = this.gson.fromJson(in, field.getGenericType());
            if (EList.class.isAssignableFrom(field.getType()) && value instanceof Collection) {
                this.assignEListProperty(instance, propertyName, (Collection)value);
            } else {
                field.set(instance, value);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    protected void assignProperty(GModelElement instance, String propertyName, JsonElement element) throws IllegalAccessException {
        try {
            Field field = this.findField(instance.getClass(), propertyName);
            Object value = this.gson.fromJson(element, field.getGenericType());
            if (EList.class.isAssignableFrom(field.getType()) && value instanceof Collection) {
                this.assignEListProperty(instance, propertyName, (Collection)value);
            } else {
                field.set(instance, value);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    protected void assignEListProperty(GModelElement instance, String propertyName, Collection<?> values) {
        EStructuralFeature feature = instance.eClass().getEStructuralFeature(propertyName);
        Object list = instance.eGet(feature);
        if (list instanceof EMap && values instanceof EMap) {
            ((EMap)list).putAll((EMap)values);
        } else if (list instanceof List) {
            ((List)list).addAll(values);
        }
    }

    @Override
    protected void writeProperties(JsonWriter out, GModelElement instance, Class<?> type, Set<String> written) throws IOException, IllegalAccessException {
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            int modifiers;
            Field field = fieldArray[n2];
            if (!EObjectExclusionStrategy.excludeField(field) && this.isSet(instance, field) && !Modifier.isTransient(modifiers = field.getModifiers()) && !Modifier.isStatic(modifiers) && written.add(field.getName())) {
                this.writeProperty(out, instance, field);
            }
            ++n2;
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            this.writeProperties(out, instance, superType, written);
        }
    }

    protected boolean isSet(GModelElement instance, Field field) {
        return instance.eIsSet(instance.eClass().getEStructuralFeature(field.getName()));
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public static class Factory
    implements TypeAdapterFactory {
        private final String typeAttribute;
        private final Map<String, EClass> typeMap;

        public Factory(String typeAttribute, Map<String, EClass> typeMap) {
            this.typeAttribute = typeAttribute;
            this.typeMap = typeMap;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GModelElement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            return new GModelElementTypeAdapter(gson, this.typeAttribute, this.typeMap);
        }
    }
}

