/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.disposable.IDisposable;
import org.eclipse.glsp.server.features.navigation.NavigationTarget;
import org.eclipse.glsp.server.features.validation.DeleteMarkersAction;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;
import org.eclipse.ui.texteditor.MarkerUtilities;

public final class GLSPDiagramEditorMarkerUtil {
    public static final String GLSP_MARKER = "org.eclipse.glsp.ide.marker.problem";
    private static final Logger LOGGER = LogManager.getLogger(GLSPDiagramEditorMarkerUtil.class);
    private static final String ATTRIBUTE_GLSP_MARKER = "glspMarker";
    private static final String ATTRIBUTE_SYNC_WITH_CLIENT = "syncWithClient";

    private GLSPDiagramEditorMarkerUtil() {
    }

    public static IMarker createMarker(IResource resource, Marker glspMarker) {
        try {
            IMarker marker = resource.createMarker(GLSP_MARKER);
            marker.setAttribute("message", (Object)glspMarker.getLabel());
            marker.setAttribute("location", (Object)glspMarker.getElementId());
            marker.setAttribute("severity", GLSPDiagramEditorMarkerUtil.toIMarkerSeverity(glspMarker));
            marker.setAttribute("priority", GLSPDiagramEditorMarkerUtil.toIMarkerPriority(glspMarker));
            marker.setAttribute(ATTRIBUTE_GLSP_MARKER, (Object)glspMarker);
            return marker;
        }
        catch (CoreException exception) {
            LOGGER.error((Object)exception);
            throw new GLSPServerException("Error during marker creation for: " + resource.getLocationURI(), (Throwable)exception);
        }
    }

    public static Optional<NavigationTarget> asNavigationTarget(IMarker marker, Optional<GModelState> modelState) {
        if (modelState.isEmpty() || !GLSP_MARKER.equals(MarkerUtilities.getMarkerType((IMarker)marker))) {
            return Optional.empty();
        }
        String elementId = marker.getAttribute("location", null);
        if (elementId == null) {
            return Optional.empty();
        }
        NavigationTarget target = new NavigationTarget((String)ClientOptionsUtil.getSourceUri((Map)modelState.get().getClientOptions()).orElseThrow(), MarkerUtilities.getMessage((IMarker)marker), new HashMap());
        target.setElementIds(Collections.singletonList(elementId));
        return Optional.of(target);
    }

    public static void clearMarkers(IResource resource, boolean syncWithClient) {
        try {
            IMarker[] iMarkerArray = resource.findMarkers(GLSP_MARKER, false, 1);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker toDelete = iMarkerArray[n2];
                toDelete.setAttribute(ATTRIBUTE_SYNC_WITH_CLIENT, syncWithClient);
                toDelete.delete();
                ++n2;
            }
        }
        catch (CoreException exception) {
            LOGGER.error((Object)exception);
            throw new GLSPServerException("Could not clear markers for: " + resource.getLocationURI(), (Throwable)exception);
        }
    }

    public static int toIMarkerSeverity(Marker glspMarker) {
        switch (glspMarker.getType()) {
            case "info": {
                return 0;
            }
            case "warning": {
                return 1;
            }
        }
        return 2;
    }

    public static int toIMarkerPriority(Marker glspMarker) {
        switch (glspMarker.getType()) {
            case "info": {
                return 0;
            }
            case "warning": {
                return 1;
            }
        }
        return 2;
    }

    public static IDisposable syncMarkers(IResource resource, String clientId, ActionDispatcher actionDispatcher) {
        MarkerDeletionListener listener = new MarkerDeletionListener(resource, actionDispatcher);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        return IDisposable.create(() -> ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener));
    }

    private static class MarkerDeletionListener
    implements IResourceChangeListener {
        private final IResource resource;
        private final ActionDispatcher actionDispatcher;

        MarkerDeletionListener(IResource resource, ActionDispatcher actionDispatcher) {
            this.resource = resource;
            this.actionDispatcher = actionDispatcher;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new MarkerDeletionVisitor(this.resource, this.actionDispatcher));
            }
            catch (CoreException exception) {
                LOGGER.error((Object)exception);
            }
        }
    }

    private static class MarkerDeletionVisitor
    implements IResourceDeltaVisitor {
        private final IResource resource;
        private final ActionDispatcher actionDispatcher;

        MarkerDeletionVisitor(IResource resource, ActionDispatcher actionDispatcher) {
            this.resource = resource;
            this.actionDispatcher = actionDispatcher;
        }

        public boolean visit(IResourceDelta resourceDelta) throws CoreException {
            if (resourceDelta == null) {
                return false;
            }
            if (this.resource.equals((Object)resourceDelta.getResource())) {
                Arrays.stream(resourceDelta.getMarkerDeltas()).filter(delta -> delta.isSubtypeOf(GLSPDiagramEditorMarkerUtil.GLSP_MARKER) && delta.getKind() == 2).forEach(this::handleMarkerDeleted);
                return false;
            }
            return true;
        }

        private void handleMarkerDeleted(IMarkerDelta markerDelta) {
            boolean sync = markerDelta.getAttribute(GLSPDiagramEditorMarkerUtil.ATTRIBUTE_SYNC_WITH_CLIENT, true);
            if (!sync) {
                return;
            }
            Object glspMarker = markerDelta.getAttribute(GLSPDiagramEditorMarkerUtil.ATTRIBUTE_GLSP_MARKER);
            if (glspMarker instanceof Marker) {
                this.actionDispatcher.dispatch((Action)new DeleteMarkersAction(Collections.singletonList((Marker)glspMarker)));
            }
        }
    }
}

