/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.gmodel.operations;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.ide.editor.clipboard.ClipboardService;
import org.eclipse.glsp.server.gmodel.GModelPasteOperationHandler;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.operations.PasteOperation;
import org.eclipse.glsp.server.utils.GeometryUtil;

public class IdeGModelPasteOperationHandler
extends GModelPasteOperationHandler {
    @Inject
    protected ClipboardService clipboard;

    @Inject
    public IdeGModelPasteOperationHandler(GraphGsonConfigurationFactory gsonFactory) {
        super(gsonFactory);
    }

    public void executeOperation(PasteOperation operation) {
        Optional<String> content = this.clipboard.getClipboardContents("application/json");
        content.ifPresent(data -> {
            ArrayList elements = this.getCopiedElements((String)data);
            GeometryUtil.shift((List)elements, (GPoint)this.computeOffset(elements, operation.getEditorContext().getLastMousePosition()));
            Map idMap = this.reassignIds(elements);
            this.filterElements(elements, idMap);
            this.rewireEdges(elements, idMap);
            ((GModelRoot)this.modelState.getRoot()).getChildren().addAll((Collection)elements);
        });
    }
}

