/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.gmf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class GMFEditPartUtils {
    public static List<?> getEditParts(List<EObject> visibleElements, DiagramEditPart diagramEditPart) {
        return GMFEditPartUtils.getEditParts(visibleElements, diagramEditPart, true);
    }

    public static List<?> getEditParts(List<EObject> visibleElements, DiagramEditPart diagramEditPart, boolean includeConnections) {
        LinkedList<GraphicalEditPart> result = new LinkedList<GraphicalEditPart>();
        for (EObject e : visibleElements) {
            Object model = diagramEditPart.getModel();
            if (!(model instanceof Diagram)) continue;
            Diagram diagram = (Diagram)model;
            TreeIterator i = EcoreUtil.getAllProperContents((EObject)diagram, (boolean)true);
            while (i.hasNext()) {
                Object part;
                View view;
                EObject current = (EObject)i.next();
                if (!(current instanceof View) || !GMFEditPartUtils.equals(e, (view = (View)current).getElement()) || !((part = diagramEditPart.getViewer().getEditPartRegistry().get(view)) instanceof GraphicalEditPart)) continue;
                result.add((GraphicalEditPart)part);
            }
        }
        if (includeConnections) {
            ArrayList tmp = new ArrayList(result);
            for (GraphicalEditPart g : tmp) {
                result.addAll(GMFEditPartUtils.findConnectionsToPaint(g, result));
            }
        }
        return result;
    }

    protected static boolean equals(EObject e, EObject fromView) {
        boolean result = false;
        if (fromView == e) {
            result = true;
        } else if (e.eResource() != null && fromView.eResource() != null) {
            Resource eResource = e.eResource();
            Resource viewResoure = fromView.eResource();
            if (eResource.getURI() != null && eResource.getURI().equals(viewResoure.getURI())) {
                result = eResource.getURIFragment(e) != null && eResource.getURIFragment(e).equals(viewResoure.getURIFragment(fromView));
            }
        }
        return result;
    }

    protected static Collection<ConnectionEditPart> findConnectionsToPaint(GraphicalEditPart editPart, List<GraphicalEditPart> relatedEditParts) {
        HashSet<GraphicalEditPart> editParts = new HashSet<GraphicalEditPart>();
        HashSet<ConnectionEditPart> connectionEPs = new HashSet<ConnectionEditPart>();
        HashSet<ConnectionEditPart> connectionsToPaint = new HashSet<ConnectionEditPart>();
        GMFEditPartUtils.getNestedEditParts(editPart, editParts);
        for (GraphicalEditPart gep : editParts) {
            connectionEPs.addAll(GMFEditPartUtils.getAllConnectionsFrom(gep));
        }
        connectionEPs.addAll(GMFEditPartUtils.getAllConnectionsFrom(editPart));
        while (!connectionEPs.isEmpty()) {
            Stack<ConnectionEditPart> connectionsPath = new Stack<ConnectionEditPart>();
            ConnectionEditPart conn = (ConnectionEditPart)connectionEPs.iterator().next();
            connectionEPs.remove(conn);
            connectionsPath.add(conn);
            EditPart target = conn.getTarget();
            while (connectionEPs.contains(target)) {
                ConnectionEditPart targetConn = (ConnectionEditPart)target;
                connectionEPs.remove(targetConn);
                connectionsPath.add(targetConn);
                target = targetConn.getTarget();
            }
            if (!editParts.contains(target) && !connectionsToPaint.contains(target) && !relatedEditParts.contains(target)) continue;
            connectionsToPaint.addAll(connectionsPath);
        }
        return connectionsToPaint;
    }

    protected static void getNestedEditParts(GraphicalEditPart baseEditPart, Collection<GraphicalEditPart> editParts) {
        for (Object child : baseEditPart.getChildren()) {
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart childEP = (GraphicalEditPart)child;
            editParts.add(childEP);
            GMFEditPartUtils.getNestedEditParts(childEP, editParts);
        }
    }

    protected static List<ConnectionEditPart> getAllConnectionsFrom(GraphicalEditPart ep) {
        LinkedList<ConnectionEditPart> connections = new LinkedList<ConnectionEditPart>();
        for (Object sourceConnObj : ep.getSourceConnections()) {
            if (!(sourceConnObj instanceof ConnectionEditPart)) continue;
            ConnectionEditPart sourceConn = (ConnectionEditPart)sourceConnObj;
            connections.add(sourceConn);
            connections.addAll(GMFEditPartUtils.getAllConnectionsFrom((GraphicalEditPart)sourceConn));
        }
        return connections;
    }
}

