/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p1cycles;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Random;

public class GreedyCycleBreaker
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(5, EnumSet.of(LayoutProcessorStrategy.REVERSED_EDGE_RESTORER));
    private int[] indeg;
    private int[] outdeg;
    private int[] mark;
    private final LinkedList<LNode> sources = new LinkedList();
    private final LinkedList<LNode> sinks = new LinkedList();

    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    /*
     * Unable to fully structure code
     */
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Greedy cycle removal", 1.0f);
        nodes = layeredGraph.getLayerlessNodes();
        unprocessedNodes = nodes.size();
        this.indeg = new int[unprocessedNodes];
        this.outdeg = new int[unprocessedNodes];
        this.mark = new int[unprocessedNodes];
        index = 0;
        for (LNode node : nodes) {
            node.id = index;
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getIncomingEdges()) {
                    if (edge.getSource().getNode() == node) continue;
                    priority = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                    v0 = index;
                    this.indeg[v0] = this.indeg[v0] + (priority > 0 ? priority + 1 : 1);
                }
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.getTarget().getNode() == node) continue;
                    priority = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                    v1 = index;
                    this.outdeg[v1] = this.outdeg[v1] + (priority > 0 ? priority + 1 : 1);
                }
            }
            if (this.outdeg[index] == 0) {
                this.sinks.add(node);
            } else if (this.indeg[index] == 0) {
                this.sources.add(node);
            }
            ++index;
        }
        nextRight = -1;
        nextLeft = 1;
        maxNodes = new ArrayList<LNode>();
        random = (Random)layeredGraph.getProperty(Properties.RANDOM);
        ** GOTO lbl65
        {
            sink = this.sinks.removeFirst();
            this.mark[sink.id] = nextRight--;
            this.updateNeighbors(sink);
            --unprocessedNodes;
            do {
                if (!this.sinks.isEmpty()) continue block4;
                while (!this.sources.isEmpty()) {
                    source = this.sources.removeFirst();
                    this.mark[source.id] = nextLeft++;
                    this.updateNeighbors(source);
                    --unprocessedNodes;
                }
                if (unprocessedNodes <= 0) continue;
                maxOutflow = -2147483648;
                for (LNode node : nodes) {
                    if (this.mark[node.id] != 0 || (outflow = this.outdeg[node.id] - this.indeg[node.id]) < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxNodes.clear();
                        maxOutflow = outflow;
                    }
                    maxNodes.add(node);
                }
                maxNode = (LNode)maxNodes.get(random.nextInt(maxNodes.size()));
                this.mark[maxNode.id] = nextLeft++;
                this.updateNeighbors(maxNode);
                --unprocessedNodes;
lbl65:
                // 3 sources

            } while (unprocessedNodes > 0);
        }
        shiftBase = nodes.size() + 1;
        index = 0;
        while (index < nodes.size()) {
            if (this.mark[index] < 0) {
                v2 = index;
                this.mark[v2] = this.mark[v2] + shiftBase;
            }
            ++index;
        }
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                var18_29 = outgoingEdges = port.getOutgoingEdges().toArray(new LEdge[0]);
                var17_28 = outgoingEdges.length;
                var16_27 = 0;
                while (var16_27 < var17_28) {
                    edge = var18_29[var16_27];
                    targetIx = edge.getTarget().getNode().id;
                    if (this.mark[node.id] > this.mark[targetIx]) {
                        edge.reverse(layeredGraph, true);
                        layeredGraph.setProperty(Properties.CYCLIC, true);
                    }
                    ++var16_27;
                }
            }
        }
        this.dispose();
        this.getMonitor().done();
    }

    private void dispose() {
        this.indeg = null;
        this.outdeg = null;
        this.mark = null;
        this.sources.clear();
        this.sinks.clear();
    }

    private void updateNeighbors(LNode node) {
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                int index;
                LPort connectedPort = edge.getSource() == port ? edge.getTarget() : edge.getSource();
                LNode endpoint = connectedPort.getNode();
                if (node == endpoint) continue;
                int priority = (Integer)edge.getProperty((IProperty)Properties.PRIORITY);
                if (priority < 0) {
                    priority = 0;
                }
                if (this.mark[index = endpoint.id] != 0) continue;
                if (edge.getTarget() == connectedPort) {
                    int n = index;
                    this.indeg[n] = this.indeg[n] - (priority + 1);
                    if (this.indeg[index] > 0 || this.outdeg[index] <= 0) continue;
                    this.sources.add(endpoint);
                    continue;
                }
                int n = index;
                this.outdeg[n] = this.outdeg[n] - (priority + 1);
                if (this.outdeg[index] > 0 || this.indeg[index] <= 0) continue;
                this.sinks.add(endpoint);
            }
        }
    }
}

