/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import java.util.Arrays;
import java.util.Comparator;

public class PortListSorter
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Port order processing", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) continue;
                this.sortPorts(node);
            }
        }
        this.getMonitor().done();
    }

    private void sortPorts(LNode node) {
        LPort[] portsArray = node.getPorts().toArray(new LPort[0]);
        Arrays.sort(portsArray, new PortComparator());
        node.getPorts().clear();
        node.getPorts().addAll(Arrays.asList(portsArray));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortComparator
    implements Comparator<LPort> {
        private PortComparator() {
        }

        @Override
        public int compare(LPort port1, LPort port2) {
            int ordinalDifference = port1.getSide().ordinal() - port2.getSide().ordinal();
            if (ordinalDifference != 0) {
                return ordinalDifference;
            }
            switch (port1.getSide()) {
                case NORTH: {
                    return this.convertDifferenceToInt(port1.getPosition().x - port2.getPosition().x);
                }
                case EAST: {
                    return this.convertDifferenceToInt(port1.getPosition().y - port2.getPosition().y);
                }
                case SOUTH: {
                    return this.convertDifferenceToInt(port2.getPosition().x - port1.getPosition().x);
                }
                case WEST: {
                    return this.convertDifferenceToInt(port2.getPosition().y - port1.getPosition().y);
                }
            }
            return 0;
        }

        private int convertDifferenceToInt(double diff) {
            if (diff < 0.0) {
                return -1;
            }
            if (diff == 0.0) {
                return 0;
            }
            return 1;
        }
    }
}

