/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;

public class LayerConstraintProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Layer constraint application", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        Layer firstLayer = layers.get(0);
        Layer lastLayer = layers.get(layers.size() - 1);
        Layer veryFirstLayer = new Layer(layeredGraph);
        Layer veryLastLayer = new Layer(layeredGraph);
        for (Layer layer : layers) {
            LNode[] nodes;
            LNode[] lNodeArray = nodes = layer.getNodes().toArray(new LNode[0]);
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                LayerConstraint constraint = (LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT));
                switch (constraint) {
                    case FIRST: {
                        node.setLayer(firstLayer);
                        break;
                    }
                    case FIRST_SEPARATE: {
                        node.setLayer(veryFirstLayer);
                        break;
                    }
                    case LAST: {
                        node.setLayer(lastLayer);
                        break;
                    }
                    case LAST_SEPARATE: {
                        node.setLayer(veryLastLayer);
                    }
                }
                ++n2;
            }
        }
        if (firstLayer.getNodes().isEmpty()) {
            layers.remove(0);
        }
        if (firstLayer != lastLayer && lastLayer.getNodes().isEmpty()) {
            layers.remove(layers.size() - 1);
        }
        if (!veryFirstLayer.getNodes().isEmpty()) {
            layers.add(0, veryFirstLayer);
        }
        if (!veryLastLayer.getNodes().isEmpty()) {
            layers.add(veryLastLayer);
        }
        this.getMonitor().done();
    }
}

