/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalPortOrthogonalEdgeRouter
extends AbstractAlgorithm
implements ILayoutProcessor {
    private double northernExtPortEdgeRoutingHeight = 0.0;

    public void reset() {
        super.reset();
        this.northernExtPortEdgeRoutingHeight = 0.0;
    }

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Orthogonally routing hierarchical port edges", 1.0f);
        Set<LNode> northSouthDummies = this.restoreNorthSouthDummies(layeredGraph);
        this.setNorthSouthDummyCoordinates(layeredGraph, northSouthDummies);
        this.routeEdges(layeredGraph, northSouthDummies);
        this.removeTemporaryNorthSouthDummies(layeredGraph);
        this.fixCoordinates(layeredGraph);
        this.correctSlantedEdgeSegments(layeredGraph);
        this.getMonitor().done();
    }

    private Set<LNode> restoreNorthSouthDummies(LGraph layeredGraph) {
        HashSet<LNode> restoredDummies = new HashSet<LNode>();
        Layer lastLayer = null;
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LNode replacedDummy;
                if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT || (replacedDummy = (LNode)node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY)) == null || replacedDummy.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
                this.restoreDummy(replacedDummy, restoredDummies);
                this.connectNodeToDummy(layeredGraph, node, replacedDummy);
            }
            lastLayer = layer;
        }
        for (LNode dummy : restoredDummies) {
            dummy.setLayer(lastLayer);
        }
        return restoredDummies;
    }

    private void restoreDummy(LNode dummy, Set<LNode> restoredDummies) {
        if (restoredDummies.contains(dummy)) {
            return;
        }
        PortSide portSide = (PortSide)dummy.getProperty(Properties.EXT_PORT_SIDE);
        LPort dummyPort = dummy.getPorts().get(0);
        if (portSide == PortSide.NORTH) {
            dummyPort.setSide(PortSide.SOUTH);
        } else if (portSide == PortSide.SOUTH) {
            dummyPort.setSide(PortSide.NORTH);
        }
        restoredDummies.add(dummy);
    }

    private void connectNodeToDummy(LGraph layeredGraph, LNode node, LNode dummy) {
        LPort outPort = new LPort(layeredGraph);
        outPort.setNode(node);
        PortSide extPortSide = (PortSide)node.getProperty(Properties.EXT_PORT_SIDE);
        outPort.setSide(extPortSide);
        LPort inPort = dummy.getPorts().get(0);
        LEdge edge = new LEdge(layeredGraph);
        edge.setSource(outPort);
        edge.setTarget(inPort);
    }

    private void setNorthSouthDummyCoordinates(LGraph layeredGraph, Set<LNode> northSouthDummies) {
        PortConstraints constraints = (PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        KVector graphSize = layeredGraph.getSize();
        LInsets.Double graphInsets = layeredGraph.getInsets();
        float borderSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        double graphWidth = graphSize.x + graphInsets.left + graphInsets.right + (double)(2.0f * borderSpacing);
        double northY = 0.0 - graphInsets.top - (double)borderSpacing - layeredGraph.getOffset().y;
        double southY = graphSize.y + graphInsets.top + graphInsets.bottom + (double)(2.0f * borderSpacing) + layeredGraph.getOffset().y;
        LinkedList<LNode> northernDummies = new LinkedList<LNode>();
        LinkedList<LNode> southernDummies = new LinkedList<LNode>();
        for (LNode dummy : northSouthDummies) {
            switch (constraints) {
                case FREE: 
                case FIXED_SIDE: 
                case FIXED_ORDER: {
                    this.calculateNorthSouthDummyPositions(dummy);
                    break;
                }
                case FIXED_RATIO: {
                    this.applyNorthSouthDummyRatio(dummy, graphWidth);
                    dummy.borderToContentAreaCoordinates(true, false);
                    break;
                }
                case FIXED_POS: {
                    this.applyNorthSouthDummyPosition(dummy);
                    dummy.borderToContentAreaCoordinates(true, false);
                    graphSize.x = Math.max(graphSize.x, dummy.getPosition().x + dummy.getSize().x / 2.0);
                }
            }
            switch ((PortSide)dummy.getProperty(Properties.EXT_PORT_SIDE)) {
                case NORTH: {
                    dummy.getPosition().y = northY;
                    northernDummies.add(dummy);
                    break;
                }
                case SOUTH: {
                    dummy.getPosition().y = southY;
                    southernDummies.add(dummy);
                }
            }
        }
        switch (constraints) {
            case FREE: 
            case FIXED_SIDE: {
                this.ensureUniquePositions(northernDummies, layeredGraph);
                this.ensureUniquePositions(southernDummies, layeredGraph);
                break;
            }
            case FIXED_ORDER: {
                this.restoreProperOrder(northernDummies, layeredGraph);
                this.restoreProperOrder(southernDummies, layeredGraph);
            }
        }
    }

    private void calculateNorthSouthDummyPositions(LNode dummy) {
        LPort dummyInPort = dummy.getPorts().get(0);
        double posSum = 0.0;
        for (LPort connectedPort : dummyInPort.getConnectedPorts()) {
            posSum += connectedPort.getNode().getPosition().x + connectedPort.getPosition().x + connectedPort.getAnchor().x;
        }
        KVector anchor = (KVector)dummy.getProperty(Properties.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = posSum / (double)dummyInPort.getDegree() - offset;
    }

    private void applyNorthSouthDummyRatio(LNode dummy, double width) {
        KVector anchor = (KVector)dummy.getProperty(Properties.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = width * (Double)dummy.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - offset;
    }

    private void applyNorthSouthDummyPosition(LNode dummy) {
        KVector anchor = (KVector)dummy.getProperty(Properties.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = (Double)dummy.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - offset;
    }

    private void ensureUniquePositions(List<LNode> dummies, LGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = dummies.toArray(new LNode[dummies.size()]);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                double diff = a.getPosition().x - b.getPosition().x;
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void restoreProperOrder(List<LNode> dummies, LGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = dummies.toArray(new LNode[dummies.size()]);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                double diff = (Double)a.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - (Double)b.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void assignAscendingCoordinates(LNode[] dummies, LGraph graph) {
        float edgeSpacing = ((Float)graph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue() * ((Float)graph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        double lastCoordinate = dummies[0].getPosition().x + dummies[0].getSize().x;
        int index = 1;
        while (index < dummies.length) {
            KVector currentPosition = dummies[index].getPosition();
            KVector currentSize = dummies[index].getSize();
            if (currentPosition.x <= lastCoordinate + (double)edgeSpacing) {
                currentPosition.x = lastCoordinate + (double)edgeSpacing;
            }
            lastCoordinate = currentPosition.x + currentSize.x;
            ++index;
        }
    }

    private void routeEdges(LGraph layeredGraph, Iterable<LNode> northSouthDummies) {
        OrthogonalRoutingGenerator routingGenerator;
        int slots;
        HashSet<LNode> northernSourceLayer = new HashSet<LNode>();
        HashSet<LNode> northernTargetLayer = new HashSet<LNode>();
        HashSet<LNode> southernSourceLayer = new HashSet<LNode>();
        HashSet<LNode> southernTargetLayer = new HashSet<LNode>();
        double nodeSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        double edgeSpacing = nodeSpacing * (double)((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        boolean debug = (Boolean)layeredGraph.getProperty(LayoutOptions.DEBUG_MODE);
        for (LNode hierarchicalPortDummy : northSouthDummies) {
            PortSide portSide = (PortSide)hierarchicalPortDummy.getProperty(Properties.EXT_PORT_SIDE);
            if (portSide == PortSide.NORTH) {
                northernTargetLayer.add(hierarchicalPortDummy);
                for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                    northernSourceLayer.add(edge.getSource().getNode());
                }
                continue;
            }
            if (portSide != PortSide.SOUTH) continue;
            southernTargetLayer.add(hierarchicalPortDummy);
            for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                southernSourceLayer.add(edge.getSource().getNode());
            }
        }
        if (!northernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(new OrthogonalRoutingGenerator.SouthToNorthRoutingStrategy(), edgeSpacing, debug ? "extnorth" : null)).routeEdges(layeredGraph, northernSourceLayer, 0, northernTargetLayer, -nodeSpacing - layeredGraph.getOffset().y)) > 0) {
            this.northernExtPortEdgeRoutingHeight = nodeSpacing + (double)(slots - 1) * edgeSpacing;
            layeredGraph.getOffset().y += this.northernExtPortEdgeRoutingHeight;
            layeredGraph.getSize().y += this.northernExtPortEdgeRoutingHeight;
        }
        if (!southernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(new OrthogonalRoutingGenerator.NorthToSouthRoutingStrategy(), edgeSpacing, debug ? "extsouth" : null)).routeEdges(layeredGraph, southernSourceLayer, 0, southernTargetLayer, layeredGraph.getSize().y + nodeSpacing - layeredGraph.getOffset().y)) > 0) {
            layeredGraph.getSize().y += nodeSpacing + (double)(slots - 1) * edgeSpacing;
        }
    }

    private void removeTemporaryNorthSouthDummies(LGraph layeredGraph) {
        LinkedList<LNode> nodesToRemove = new LinkedList<LNode>();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LEdge edge;
                LEdge[] edges;
                if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT || node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY) == null) continue;
                LPort nodeInPort = null;
                LPort nodeOutPort = null;
                LPort nodeOriginPort = null;
                for (LPort port : node.getPorts()) {
                    switch (port.getSide()) {
                        case WEST: {
                            nodeInPort = port;
                            break;
                        }
                        case EAST: {
                            nodeOutPort = port;
                            break;
                        }
                        default: {
                            nodeOriginPort = port;
                        }
                    }
                }
                LEdge nodeToOriginEdge = nodeOriginPort.getOutgoingEdges().get(0);
                if (node.getProperty(Properties.EXT_PORT_SIDE) == PortSide.NORTH) {
                    nodeToOriginEdge.getBendPoints().translate(0.0, -this.northernExtPortEdgeRoutingHeight);
                }
                KVectorChain incomingEdgeBendPoints = new KVectorChain((Collection)nodeToOriginEdge.getBendPoints());
                KVector firstBendPoint = new KVector(nodeInPort.getPosition());
                firstBendPoint.add(new KVector(node.getPosition()));
                incomingEdgeBendPoints.add(0, (Object)firstBendPoint);
                KVectorChain outgoingEdgeBendPoints = KVectorChain.reverse((KVectorChain)nodeToOriginEdge.getBendPoints());
                KVector lastBendPoint = new KVector(nodeOutPort.getPosition());
                lastBendPoint.add(new KVector(node.getPosition()));
                outgoingEdgeBendPoints.add((Object)lastBendPoint);
                LNode replacedDummy = (LNode)node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY);
                LPort replacedDummyPort = replacedDummy.getPorts().get(0);
                LEdge[] lEdgeArray = edges = nodeInPort.getIncomingEdges().toArray(new LEdge[0]);
                int n = edges.length;
                int n2 = 0;
                while (n2 < n) {
                    edge = lEdgeArray[n2];
                    edge.setTarget(replacedDummyPort);
                    edge.getBendPoints().addAll((Collection)incomingEdgeBendPoints);
                    ++n2;
                }
                lEdgeArray = edges = nodeOutPort.getOutgoingEdges().toArray(new LEdge[0]);
                n = edges.length;
                n2 = 0;
                while (n2 < n) {
                    edge = lEdgeArray[n2];
                    edge.setSource(replacedDummyPort);
                    edge.getBendPoints().addAll(0, (Collection)outgoingEdgeBendPoints);
                    ++n2;
                }
                nodeToOriginEdge.setSource(null);
                nodeToOriginEdge.setTarget(null);
                nodesToRemove.add(node);
            }
        }
        for (LNode node : nodesToRemove) {
            node.setLayer(null);
        }
    }

    private void fixCoordinates(LGraph layeredGraph) {
        PortConstraints constraints = (PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        List<Layer> layers = layeredGraph.getLayers();
        this.fixCoordinates(layers.get(0), constraints, layeredGraph);
        this.fixCoordinates(layers.get(layers.size() - 1), constraints, layeredGraph);
    }

    private void fixCoordinates(Layer layer, PortConstraints constraints, LGraph graph) {
        PortSide extPortSide;
        LInsets.Double insets = graph.getInsets();
        float borderSpacing = ((Float)graph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        KVector offset = graph.getOffset();
        KVector graphActualSize = graph.getActualSize();
        double newActualGraphHeight = graphActualSize.y;
        for (LNode node : layer) {
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
            extPortSide = (PortSide)node.getProperty(Properties.EXT_PORT_SIDE);
            KVector extPortSize = (KVector)node.getProperty(Properties.EXT_PORT_SIZE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case EAST: {
                    nodePosition.x = graph.getSize().x + (double)borderSpacing + insets.right - offset.x;
                    break;
                }
                case WEST: {
                    nodePosition.x = -offset.x - (double)borderSpacing - insets.left;
                }
            }
            double requiredActualGraphHeight = 0.0;
            switch (extPortSide) {
                case EAST: 
                case WEST: {
                    if (constraints == PortConstraints.FIXED_RATIO) {
                        double ratio = (Double)node.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
                        nodePosition.y = graphActualSize.y * ratio - ((KVector)node.getProperty(Properties.PORT_ANCHOR)).y;
                        requiredActualGraphHeight = nodePosition.y + extPortSize.y;
                        node.borderToContentAreaCoordinates(false, true);
                        break;
                    }
                    if (constraints != PortConstraints.FIXED_POS) break;
                    nodePosition.y = (Double)node.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - ((KVector)node.getProperty(Properties.PORT_ANCHOR)).y;
                    requiredActualGraphHeight = nodePosition.y + extPortSize.y;
                    node.borderToContentAreaCoordinates(false, true);
                }
            }
            newActualGraphHeight = Math.max(newActualGraphHeight, requiredActualGraphHeight);
        }
        graph.getSize().y += newActualGraphHeight - graphActualSize.y;
        for (LNode node : layer) {
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
            extPortSide = (PortSide)node.getProperty(Properties.EXT_PORT_SIDE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case NORTH: {
                    nodePosition.y = -offset.y - (double)borderSpacing - insets.top;
                    break;
                }
                case SOUTH: {
                    nodePosition.y = graph.getSize().y + (double)borderSpacing + insets.bottom - offset.y;
                }
            }
        }
    }

    private void correctSlantedEdgeSegments(LGraph layeredGraph) {
        List<Layer> layers = layeredGraph.getLayers();
        this.correctSlantedEdgeSegments(layers.get(0));
        this.correctSlantedEdgeSegments(layers.get(layers.size() - 1));
    }

    private void correctSlantedEdgeSegments(Layer layer) {
        for (LNode node : layer) {
            PortSide extPortSide;
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT || (extPortSide = (PortSide)node.getProperty(Properties.EXT_PORT_SIDE)) != PortSide.EAST && extPortSide != PortSide.WEST) continue;
            for (LEdge edge : node.getConnectedEdges()) {
                KVectorChain bendPoints = edge.getBendPoints();
                if (bendPoints.isEmpty()) continue;
                LPort sourcePort = edge.getSource();
                KVector firstBendPoint = (KVector)bendPoints.getFirst();
                if (sourcePort.getNode() == node) {
                    firstBendPoint.y = node.getPosition().y + sourcePort.getPosition().y + sourcePort.getAnchor().y;
                }
                LPort targetPort = edge.getTarget();
                KVector lastBendPoint = (KVector)bendPoints.getLast();
                if (targetPort.getNode() != node) continue;
                lastBendPoint.y = node.getPosition().y + targetPort.getPosition().y + targetPort.getAnchor().y;
            }
        }
    }
}

