/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundNodeCountAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.compoundNodeCount";

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Compound Nodes Analysis", 1.0f);
        int compoundNodes = 0;
        LinkedList<KNode> nodeQueue = new LinkedList<KNode>();
        nodeQueue.add(parentNode);
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            EList children = node.getChildren();
            if (children.isEmpty()) continue;
            ++compoundNodes;
            nodeQueue.addAll((Collection<KNode>)children);
        }
        compoundNodes = Math.max(0, compoundNodes - 1);
        progressMonitor.done();
        return compoundNodes;
    }
}

