/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etphys.eTPhys;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ThreadModel implements Enumerator
{
    SINGLE_THREADED(0, "SINGLE_THREADED", "singleThreaded"),
    MULTI_THREADED(1, "MULTI_THREADED", "multiThreaded");

    public static final int SINGLE_THREADED_VALUE = 0;
    public static final int MULTI_THREADED_VALUE = 1;
    private static final ThreadModel[] VALUES_ARRAY;
    public static final List<ThreadModel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ThreadModel[]{SINGLE_THREADED, MULTI_THREADED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ThreadModel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThreadModel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThreadModel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThreadModel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThreadModel get(int value) {
        switch (value) {
            case 0: {
                return SINGLE_THREADED;
            }
            case 1: {
                return MULTI_THREADED;
            }
        }
        return null;
    }

    private ThreadModel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

