/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.refactoring;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.EmfResourceReferenceUpdater;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DiagramReferenceUpdater
extends EmfResourceReferenceUpdater {
    @Inject
    private DiagramAccessBase diagramAccess;

    protected void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        super.createReferenceUpdates(elementRenameArguments, resource2references, resourceSet, updateAcceptor, monitor);
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Procedures.Procedure1 procedure1 = map -> {
            Functions.Function1 function1 = uri -> resourceSet.getResource(uri, false);
            Functions.Function1 function12 = it -> it.getContents();
            Consumer<Diagram> consumer = diagram -> map.put((Object)((EObject)IterableExtensions.head((Iterable)diagram.getLink().getBusinessObjects())), diagram);
            Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)resource2references.keySet(), (Functions.Function1)function1), (Functions.Function1)function12)), Diagram.class).forEach(consumer);
        };
        ArrayListMultimap diagramMap = (ArrayListMultimap)ObjectExtensions.operator_doubleArrow((Object)arrayListMultimap, (Procedures.Procedure1)procedure1);
        Functions.Function1 function1 = origURI -> resourceSet.getEObject(elementRenameArguments.getNewElementURI(origURI), false);
        Consumer<ModelComponent> consumer = mc -> {
            Functions.Function1 function1 = it -> it.eResource().getURI().isPlatformResource();
            List wsDiagrams = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)diagramMap.get(mc), (Functions.Function1)function1));
            String newFileName = this.diagramAccess.getDigramFileName((EObject)mc);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Functions.Function1 function12 = it -> {
                String string = IterableExtensions.join((Iterable)IterableExtensions.tail((Iterable)it.eResource().getURI().segmentsList()), (CharSequence)"/");
                Path path = new Path(string);
                return workspaceRoot.getFile((IPath)path).getParent();
            };
            Map parents = IterableExtensions.groupBy((Iterable)wsDiagrams, (Functions.Function1)function12);
            BiConsumer<IContainer, List> biConsumer = (parent, diagrams) -> {
                Functions.Function1 function1 = it -> it.eResource().getTimeStamp();
                Diagram diagram = (Diagram)IterableExtensions.maxBy((Iterable)diagrams, (Functions.Function1)function1);
                String string2 = IterableExtensions.join((Iterable)IterableExtensions.tail((Iterable)diagram.eResource().getURI().segmentsList()), (CharSequence)"/");
                Path path = new Path(string2);
                IFile diagFile = workspaceRoot.getFile((IPath)path);
                URI uRI = diagram.eResource().getURI();
                IPath iPath = diagFile.getFullPath();
                RenameResourceChange renameResourceChange = new RenameResourceChange(iPath, newFileName);
                updateAcceptor.accept(uRI, (Change)renameResourceChange);
            };
            parents.forEach(biConsumer);
        };
        Iterables.filter((Iterable)IterableExtensions.map((Iterable)elementRenameArguments.getRenamedElementURIs(), (Functions.Function1)function1), ModelComponent.class).forEach(consumer);
    }
}

