/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtil;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ValidationUtil
extends FSMValidationUtil {
    public static final String CONNECTED_SUB_COMPONENT_PORTS_MUST_BE_CONJUGATED_TO_EACH_OTHER = "connected sub component ports must be conjugated to each other";
    @Inject
    private RoomHelpers roomHelpers;

    public FSMValidationUtilXtend.Result isConnectable(Port port, ActorContainerRef ref, StructureClass acc) {
        return this.isConnectable(port, ref, acc, null);
    }

    public FSMValidationUtilXtend.Result isConnectable(Port port, ActorContainerRef ref, StructureClass acc, Binding exclude) {
        if (!this.isMultipleConnectable(port, ref) && this.isConnected(port, ref, acc, exclude)) {
            return FSMValidationUtilXtend.Result.error((String)"port with multiplicity 1 is already connected");
        }
        if (this.roomHelpers.getInterfaceItems(acc, true).contains(port) && this.roomHelpers.isExternal(port)) {
            return FSMValidationUtilXtend.Result.error((String)"external end ports must not be connected");
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public boolean isMultipleConnectable(Port port, ActorContainerRef ref) {
        if (port.isReplicated()) {
            return true;
        }
        if (ref != null && ref instanceof ActorRef && ((ActorRef)ref).getMultiplicity() > 1) {
            return true;
        }
        if (port.getProtocol() instanceof ProtocolClass && port.getProtocol().getCommType() == CommunicationType.DATA_DRIVEN) {
            if (ref == null) {
                if (this.roomHelpers.isRelay(port)) {
                    return !port.isConjugated();
                }
                return port.isConjugated();
            }
            return port.isConjugated();
        }
        return false;
    }

    public FSMValidationUtilXtend.Result isValid(Binding bind) {
        return this.isConnectable(bind.getEndpoint1().getPort(), bind.getEndpoint1().getActorRef(), bind.getEndpoint2().getPort(), bind.getEndpoint2().getActorRef(), (StructureClass)bind.eContainer(), bind);
    }

    public FSMValidationUtilXtend.Result isConnectable(BindingEndPoint ep1, BindingEndPoint ep2, StructureClass sc) {
        return this.isConnectable(ep1.getPort(), ep1.getActorRef(), ep2.getPort(), ep2.getActorRef(), sc);
    }

    public FSMValidationUtilXtend.Result isConnectable(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2, StructureClass sc) {
        return this.isConnectable(p1, ref1, p2, ref2, sc, null);
    }

    public FSMValidationUtilXtend.Result isConnectable(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2, StructureClass sc, Binding exclude) {
        ProtocolClass pc2;
        if (p1 == p2) {
            return FSMValidationUtilXtend.Result.error((String)"no self connection allowed, ports are identical");
        }
        boolean pc1extendsIncoming = false;
        boolean pc1extendsOutgoing = false;
        boolean pc2extendsIncoming = false;
        boolean pc2extendsOutgoing = false;
        ProtocolClass pc1 = p1.getProtocol();
        if (pc1 != (pc2 = p2.getProtocol())) {
            if (this.roomHelpers.isDerivedFrom(pc1, pc2)) {
                if (this.roomHelpers.getAllMessages(pc1, true).size() > this.roomHelpers.getAllMessages(pc2, true).size()) {
                    pc1extendsIncoming = true;
                }
                if (this.roomHelpers.getAllMessages(pc1, false).size() > this.roomHelpers.getAllMessages(pc2, false).size()) {
                    pc1extendsOutgoing = true;
                }
                if (pc1extendsIncoming && pc1extendsOutgoing) {
                    return FSMValidationUtilXtend.Result.error((String)"derived protocols not connectable (both directions extended)");
                }
            } else if (this.roomHelpers.isDerivedFrom(pc2, pc1)) {
                if (this.roomHelpers.getAllMessages(pc2, true).size() > this.roomHelpers.getAllMessages(pc1, true).size()) {
                    pc2extendsIncoming = true;
                }
                if (this.roomHelpers.getAllMessages(pc2, false).size() > this.roomHelpers.getAllMessages(pc1, false).size()) {
                    pc2extendsOutgoing = true;
                }
                if (pc2extendsIncoming && pc2extendsOutgoing) {
                    return FSMValidationUtilXtend.Result.error((String)"derived protocols not connectable (both directions extended)");
                }
            } else {
                if (pc1.getName().equals(pc2.getName())) {
                    String ns2;
                    String ns1 = ((RoomModel)pc1.eContainer()).getName();
                    if (!ns1.equals(ns2 = ((RoomModel)pc2.eContainer()).getName())) {
                        return FSMValidationUtilXtend.Result.error((String)"protocols have different name spaces");
                    }
                    if (pc1.eResource() != pc2.eResource()) {
                        return FSMValidationUtilXtend.Result.error((String)"protocols were not loaded uniquely - check imports");
                    }
                    return FSMValidationUtilXtend.Result.error((String)"protocols don't match (but have same name)");
                }
                return FSMValidationUtilXtend.Result.error((String)"protocols don't match");
            }
        }
        if (pc1.getCommType() != pc2.getCommType()) {
            return FSMValidationUtilXtend.Result.error((String)"protocol communication types don't match");
        }
        if (this.alreadyConnected(p1, ref1, p2, ref2, sc, exclude)) {
            return FSMValidationUtilXtend.Result.error((String)"ports are already bound");
        }
        if (ref1 == null && ref2 == null) {
            return FSMValidationUtilXtend.Result.error((String)"cannot connect two local ports");
        }
        if (ref1 != null && ref2 != null) {
            if (ref1 == ref2) {
                return FSMValidationUtilXtend.Result.error((String)"ports of one ref must not be connected");
            }
            if (p1.isConjugated() == p2.isConjugated()) {
                return FSMValidationUtilXtend.Result.error((String)CONNECTED_SUB_COMPONENT_PORTS_MUST_BE_CONJUGATED_TO_EACH_OTHER);
            }
            if (p1.isConjugated() && pc1extendsIncoming) {
                return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
            }
            if (p2.isConjugated() && pc2extendsIncoming) {
                return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
            }
            if (!p1.isConjugated() && pc1extendsOutgoing) {
                return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
            }
            if (!p2.isConjugated() && pc2extendsOutgoing) {
                return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
            }
            FSMValidationUtilXtend.Result result = this.isConnectable(p1, ref1, sc, exclude);
            if (!result.isOk()) {
                return result;
            }
            result = this.isConnectable(p2, ref2, sc, exclude);
            if (!result.isOk()) {
                return result;
            }
        } else {
            ActorContainerRef ref;
            Port local = ref1 == null ? p1 : p2;
            Port sub = ref1 != null ? p1 : p2;
            ActorContainerRef actorContainerRef = ref = ref1 != null ? ref1 : ref2;
            if (ref instanceof ActorRef && ((ActorRef)ref).getRefType() == ReferenceType.OPTIONAL && ((ActorRef)ref).getMultiplicity() == -1 && local.getMultiplicity() != -1) {
                return FSMValidationUtilXtend.Result.error((String)("local port '" + local.getName() + "' must have multiplicity any"));
            }
            if (this.roomHelpers.isRelay(local)) {
                ActorContainerClass acc;
                FSMValidationUtilXtend.Result result;
                if (local.isConjugated() != sub.isConjugated()) {
                    return FSMValidationUtilXtend.Result.error((String)"relay port must have same direction as local port");
                }
                if (local == p1) {
                    if (!p1.isConjugated() && pc1extendsIncoming) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
                    }
                    if (p2.isConjugated() && pc2extendsIncoming) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
                    }
                    if (p1.isConjugated() && pc1extendsOutgoing) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
                    }
                    if (!p2.isConjugated() && pc2extendsOutgoing) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
                    }
                } else {
                    if (p1.isConjugated() && pc1extendsIncoming) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
                    }
                    if (!p2.isConjugated() && pc2extendsIncoming) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
                    }
                    if (!p1.isConjugated() && pc1extendsOutgoing) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
                    }
                    if (p2.isConjugated() && pc2extendsOutgoing) {
                        return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
                    }
                }
                if (!(result = this.isConnectable(local, null, acc = (ActorContainerClass)ref.eContainer(), exclude)).isOk()) {
                    return result;
                }
                result = this.isConnectable(sub, ref, acc, exclude);
                if (!result.isOk()) {
                    return result;
                }
            } else {
                if (local.isConjugated() == sub.isConjugated()) {
                    return FSMValidationUtilXtend.Result.error((String)"internal end port must have opposite direction");
                }
                if (p1.isConjugated() && pc1extendsIncoming) {
                    return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
                }
                if (p2.isConjugated() && pc2extendsIncoming) {
                    return FSMValidationUtilXtend.Result.error((String)"protocol extends incoming");
                }
                if (!p1.isConjugated() && pc1extendsOutgoing) {
                    return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
                }
                if (!p2.isConjugated() && pc2extendsOutgoing) {
                    return FSMValidationUtilXtend.Result.error((String)"protocol extends outgoing");
                }
                FSMValidationUtilXtend.Result result = this.isConnectable(sub, ref, sc, exclude);
                if (!result.isOk()) {
                    return result;
                }
                result = this.isConnectable(local, null, sc, exclude);
                if (!result.isOk()) {
                    return result;
                }
            }
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    private boolean alreadyConnected(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2, StructureClass sc, Binding exclude) {
        HashSet<String> bindings = new HashSet<String>();
        String key = this.getKey(p1, ref1, p2, ref2);
        bindings.add(key);
        for (Binding bind : sc.getBindings()) {
            if (bind == exclude || bindings.add(key = this.getKey(bind.getEndpoint1().getPort(), bind.getEndpoint1().getActorRef(), bind.getEndpoint2().getPort(), bind.getEndpoint2().getActorRef()))) continue;
            return true;
        }
        return false;
    }

    private String getKey(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2) {
        String ep2;
        String ep1 = this.getEndpointName(p1, ref1);
        return ep1.compareTo(ep2 = this.getEndpointName(p2, ref2)) > 0 ? String.valueOf(ep1) + ep2 : String.valueOf(ep2) + ep1;
    }

    private String getEndpointName(Port p1, ActorContainerRef ref1) {
        if (ref1 == null) {
            return String.valueOf(p1.getName()) + "#.";
        }
        return String.valueOf(p1.getName()) + "#" + ref1.getName();
    }

    public FSMValidationUtilXtend.Result isFreeOfReferences(Port port) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)port, (ResourceSet)port.eResource().getResourceSet());
        boolean bound = false;
        boolean usedByFSM = false;
        for (EStructuralFeature.Setting ref : refs) {
            if (ref.getEObject() instanceof BindingEndPoint) {
                bound = true;
                continue;
            }
            if (!(ref.getEObject() instanceof MessageFromIf)) continue;
            usedByFSM = true;
        }
        if (bound && usedByFSM) {
            return FSMValidationUtilXtend.Result.error((String)"port is bound and also used by state machine (triggers)");
        }
        if (bound) {
            return FSMValidationUtilXtend.Result.error((String)"port is bound (may be externally)");
        }
        if (usedByFSM) {
            return FSMValidationUtilXtend.Result.error((String)"port is used by state machine (triggers)");
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public boolean isReferencedAsReplicatedInModel(ActorClass ac) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)ac, (ResourceSet)ac.eResource().getResourceSet());
        for (EStructuralFeature.Setting ref : refs) {
            if (!(ref.getEObject() instanceof ActorRef)) continue;
            return ((ActorRef)ref.getEObject()).getMultiplicity() > 1;
        }
        return false;
    }

    public boolean isConnected(Port port, ActorContainerRef ref, StructureClass sc) {
        return this.isConnected(port, ref, sc, null);
    }

    public boolean isConnected(Port port, ActorContainerRef ref, StructureClass sc, Binding exclude) {
        for (Binding bind : sc.getBindings()) {
            if (bind == exclude) continue;
            if (this.isEndpoint(bind.getEndpoint1(), port, ref)) {
                return true;
            }
            if (!this.isEndpoint(bind.getEndpoint2(), port, ref)) continue;
            return true;
        }
        if (sc instanceof ActorClass && ((ActorClass)sc).getActorBase() != null) {
            return this.isConnected(port, ref, ((ActorClass)sc).getActorBase(), exclude);
        }
        return false;
    }

    private boolean isEndpoint(BindingEndPoint ep, Port port, ActorContainerRef ref) {
        return ep.getActorRef() == ref && ep.getPort() == port;
    }

    public boolean isRelay(SPP spp) {
        ActorContainerClass acc = (ActorContainerClass)spp.eContainer();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                if (svc.getSpp() != spp) continue;
                return false;
            }
        }
        return true;
    }

    public FSMValidationUtilXtend.Result isValid(LayerConnection lc) {
        if (lc.getFrom() instanceof RelaySAPoint) {
            return this.isConnectable(((RelaySAPoint)lc.getFrom()).getRelay(), null, lc.getTo().getService(), lc.getTo().getRef(), (StructureClass)lc.eContainer(), lc);
        }
        if (lc.getFrom() instanceof RefSAPoint) {
            return this.isConnectable(null, ((RefSAPoint)lc.getFrom()).getRef(), lc.getTo().getService(), lc.getTo().getRef(), (StructureClass)lc.eContainer(), lc);
        }
        assert (false) : "unexpected sub type";
        return FSMValidationUtilXtend.Result.error((String)"internal error");
    }

    public FSMValidationUtilXtend.Result isConnectable(SPP src, ActorContainerRef srcRef, SPP tgt, ActorContainerRef tgtRef, StructureClass ac) {
        return this.isConnectable(src, srcRef, tgt, tgtRef, ac, null);
    }

    public FSMValidationUtilXtend.Result isConnectable(SPP src, ActorContainerRef srcRef, SPP dst, ActorContainerRef dstRef, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return FSMValidationUtilXtend.Result.error((String)"internal error");
        }
        if (src == null && srcRef == null || src != null && srcRef != null) {
            return FSMValidationUtilXtend.Result.error((String)"source can be an own SPP _or_ a ref");
        }
        if (dst == null || dstRef == null) {
            return FSMValidationUtilXtend.Result.error((String)"destination must be an SPP on a ref");
        }
        if (src != null && this.isConnectedSrc(src, sc, exclude)) {
            return FSMValidationUtilXtend.Result.error((String)"source SPP is already connected");
        }
        return FSMValidationUtilXtend.Result.ok();
    }

    public boolean isConnectableSrc(SPP src, ActorContainerRef ref, StructureClass sc) {
        return this.isConnectableSrc(src, ref, sc, null);
    }

    public boolean isConnectableSrc(SPP src, ActorContainerRef ref, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return false;
        }
        if (src == null && ref == null || src != null && ref != null) {
            return false;
        }
        if (ref instanceof ActorRef && ((ActorRef)ref).getMultiplicity() > 1) {
            return false;
        }
        return src == null || !this.isConnectedSrc(src, sc, exclude);
    }

    public boolean isReferencedInModel(SPP spp) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)spp, (ResourceSet)spp.eResource().getResourceSet());
        for (EStructuralFeature.Setting ref : refs) {
            if (ref.getEObject() instanceof ServiceImplementation) {
                return true;
            }
            if (ref.getEObject() instanceof RelaySAPoint) {
                return true;
            }
            if (!(ref.getEObject() instanceof SPPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectedSrc(SPP src, StructureClass sc) {
        return this.isConnectedSrc(src, sc, null);
    }

    public boolean isConnectedSrc(SPP src, StructureClass sc, LayerConnection exclude) {
        for (LayerConnection lc : sc.getConnections()) {
            if (lc == exclude || !(lc.getFrom() instanceof RelaySAPoint) || ((RelaySAPoint)lc.getFrom()).getRelay() != src) continue;
            return true;
        }
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                if (svc.getSpp() != src) continue;
                return true;
            }
            if (ac.getActorBase() != null) {
                return this.isConnectedSrc(src, ac.getActorBase(), exclude);
            }
        }
        return false;
    }

    public boolean isConnectableDst(SPP src, ActorContainerRef ref, StructureClass sc) {
        return this.isConnectableDst(src, ref, sc, null);
    }

    public boolean isConnectableDst(SPP dst, ActorContainerRef ref, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return false;
        }
        if (dst == null || ref == null) {
            return false;
        }
        return dst == null || !this.isConnectedDst(dst, ref, sc, exclude);
    }

    public boolean isConnectedDst(SPP src, ActorContainerRef acr, StructureClass sc) {
        return this.isConnectedDst(src, acr, sc, null);
    }

    public boolean isConnectedDst(SPP src, ActorContainerRef acr, StructureClass sc, LayerConnection exclude) {
        for (LayerConnection lc : sc.getConnections()) {
            if (lc == exclude || lc.getTo().getService() != src || lc.getTo().getRef() != acr) continue;
            return true;
        }
        if (sc instanceof ActorClass && ((ActorClass)sc).getActorBase() != null) {
            return this.isConnectedDst(src, acr, ((ActorClass)sc).getActorBase(), exclude);
        }
        return false;
    }

    public FSMValidationUtilXtend.Result isUniqueName(InterfaceItem item) {
        return this.isUniqueName(item, item.getName());
    }

    public FSMValidationUtilXtend.Result isUniqueName(InterfaceItem item, String name) {
        block8: {
            block7: {
                if (name.isEmpty()) {
                    return FSMValidationUtilXtend.Result.error((String)"name must not be empty");
                }
                if (!this.isValidID(name)) {
                    return FSMValidationUtilXtend.Result.error((String)"name is no valid ID");
                }
                if (!(item.eContainer() instanceof ActorClass)) break block7;
                ArrayList<InterfaceItem> all = new ArrayList<InterfaceItem>();
                ActorClass ac = (ActorClass)item.eContainer();
                if (this.roomHelpers.isCircularClassHierarchy(ac)) {
                    return FSMValidationUtilXtend.Result.ok();
                }
                do {
                    all.addAll((Collection<InterfaceItem>)ac.getInterfacePorts());
                    all.addAll((Collection<InterfaceItem>)ac.getInternalPorts());
                    all.addAll((Collection<InterfaceItem>)ac.getServiceProvisionPoints());
                    all.addAll((Collection<InterfaceItem>)ac.getServiceAccessPoints());
                } while ((ac = ac.getActorBase()) != null);
                for (InterfaceItem ii : all) {
                    if (ii == item || !ii.getName().equals(name)) continue;
                    if (ii.eContainer() != item.eContainer()) {
                        return FSMValidationUtilXtend.Result.error((String)("name already used in base class " + ((ActorClass)ii.eContainer()).getName()));
                    }
                    return FSMValidationUtilXtend.Result.error((String)"name already used");
                }
                break block8;
            }
            if (!(item.eContainer() instanceof SubSystemClass)) break block8;
            SubSystemClass ssc = (SubSystemClass)item.eContainer();
            ArrayList<InterfaceItem> all = new ArrayList<InterfaceItem>();
            all.addAll((Collection<InterfaceItem>)ssc.getServiceProvisionPoints());
            all.addAll((Collection<InterfaceItem>)ssc.getRelayPorts());
            for (InterfaceItem ii : all) {
                if (ii == item || !ii.getName().equals(name)) continue;
                return FSMValidationUtilXtend.Result.error((String)"name already used");
            }
        }
        return FSMValidationUtilXtend.Result.ok();
    }
}

