/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;

public class CurlyBraceIfElseGenerator
implements IfElseGenerator {
    private int numberAdditionalIndents;

    @Override
    public boolean branchIsSafeScope() {
        return true;
    }

    @Override
    public void generateIf(ExprCode guard, CodeBox code) {
        code.add((Box)guard.getCode());
        code.add("if (%s) {", new Object[]{guard.getData()});
        code.indent();
        this.numberAdditionalIndents = 0;
    }

    @Override
    public void generateElseIf(ExprCode guard, CodeBox code) {
        if (guard.hasCode()) {
            code.dedent();
            code.add("} else {");
            code.indent();
            code.add((Box)guard.getCode());
            code.add("if (%s) {", new Object[]{guard.getData()});
            code.indent();
            ++this.numberAdditionalIndents;
        } else {
            code.dedent();
            code.add("} else if (%s) {", new Object[]{guard.getData()});
            code.indent();
        }
    }

    @Override
    public void generateElse(CodeBox code) {
        code.dedent();
        code.add("} else {");
        code.indent();
    }

    @Override
    public void generateEndIf(CodeBox code) {
        while (this.numberAdditionalIndents >= 0) {
            code.dedent();
            code.add("}");
            --this.numberAdditionalIndents;
        }
    }
}

