//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2025, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.merger;

import static org.eclipse.escet.common.java.Strings.fmt;

import org.eclipse.escet.common.app.framework.options.BooleanOption;
import org.eclipse.escet.common.app.framework.options.Options;

/** Option to configure whether to make the merged specification a partial specification. */
public class MergedSpecIsPartialOption extends BooleanOption {
    /** Default value of the option. */
    private static final boolean DEFAULT_VALUE = false;

    /** Constructor for the {@link MergedSpecIsPartialOption} class. */
    public MergedSpecIsPartialOption() {
        super(
                // name
                "Merged specification is partial",

                // description
                fmt("Whether to make the merged specification a partial specification. [DEFAULT=%s]", DEFAULT_VALUE),

                // cmdShort
                'p',

                // cmdLong
                "partial",

                // cmdValue
                "BOOL",

                // defaultValue
                DEFAULT_VALUE,

                // showInDialog
                true,

                // optDialogDescr
                "Whether to make the merged specification a partial specification.",

                // optDialogCheckboxText
                "Make it partial"

        );
    }

    /**
     * Returns whether the merged specification is to be made partial.
     *
     * @return {@code true} if the merged specification should be partial, {@code false} otherwise.
     */
    public static boolean isPartial() {
        return Options.get(MergedSpecIsPartialOption.class);
    }
}
