/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.output;

import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputMode;

public class OutputModeOption
extends EnumOption<OutputMode> {
    public static final OutputMode DEFAULT_VALUE = OutputMode.NORMAL;

    public OutputModeOption() {
        super("Output mode", "The output mode. Specify \"error\" for errors only; \"warning\" for errors and warnings only; \"normal\" (default) for errors, warnings, and 'normal' output; or \"debug\" for errors, warnings, 'normal', and debug output.", Character.valueOf('m'), "output-mode", "OUTMODE", DEFAULT_VALUE, true, "The application's output mode.");
    }

    public static OutputMode getOutputMode() {
        return (OutputMode)((Object)Options.get(OutputModeOption.class));
    }

    @Override
    protected String getDialogText(OutputMode value) {
        switch (value) {
            case ERROR: {
                return "Error: error output only";
            }
            case WARNING: {
                return "Warning: error and warning output only";
            }
            case NORMAL: {
                return "Normal: error, warning, and 'normal' output";
            }
            case DEBUG: {
                return "Debug: error, warning, 'normal' and debug output";
            }
        }
        throw new RuntimeException("Unknown value: " + String.valueOf((Object)value));
    }

    @Override
    public void postProcessValue(OutputMode value) {
        super.postProcessValue(value);
    }

    @Override
    public void verifyValue(OutputMode value) {
        super.verifyValue(value);
    }
}

