/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.internal.chartpart.Annotation;

public class AnnotationLine
extends Annotation {
    private final boolean isVertical;
    private double value;

    public AnnotationLine(double value, boolean isVertical, boolean isValueInScreenSpace) {
        super(isValueInScreenSpace);
        this.value = value;
        this.isVertical = isVertical;
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.isVisible) {
            return;
        }
        int lineWidth = (int)this.styler.getAnnotationLineStroke().getLineWidth();
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (this.isVertical) {
            y1 = this.getYAxisScreenValueForMax() + lineWidth / 2;
            y2 = this.getYAxisScreenValueForMin() - lineWidth / 2;
        } else {
            x1 = this.getXAxisScreenValueForMin() + lineWidth / 2;
            x2 = this.getXAxisScreenValueForMax() - lineWidth / 2;
        }
        if (this.isValueInScreenSpace) {
            if (this.isVertical) {
                x2 = x1 = (int)this.value;
            } else {
                y2 = y1 = this.chart.getHeight() - (int)this.value;
            }
        } else if (this.isVertical) {
            x2 = x1 = this.getXAxisScreenValue(this.value);
        } else {
            y2 = y1 = this.getYAxisScreenValue(this.value);
        }
        g.setStroke(this.styler.getAnnotationLineStroke());
        g.setColor(this.styler.getAnnotationLineColor());
        g.drawLine(x1, y1, x2, y2);
        this.bounds = new Rectangle2D.Double(x1, y1, Math.max(x2 - x1, lineWidth), Math.max(y2 - y1, lineWidth));
    }

    public void setValue(double value) {
        this.value = value;
    }
}

