/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.escet.common.app.framework.javacompiler.JavaInputFileObject;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.JavaCodeUtils;
import org.eclipse.escet.common.java.Lists;

public class JavaCodeFile
extends JavaInputFileObject {
    public final String packageName;
    public final String name;
    public final List<String> imports = Lists.list();
    public final CodeBox header = new MemoryCodeBox();
    public final CodeBox body = new MemoryCodeBox();

    public JavaCodeFile(String packageName, String name) {
        super(JavaCodeFile.getAbsClassName(packageName, name));
        this.packageName = packageName;
        this.name = name;
    }

    public String getAbsClassName() {
        return JavaCodeFile.getAbsClassName(this.packageName, this.name);
    }

    private static String getAbsClassName(String packageName, String name) {
        return packageName + (packageName.isEmpty() ? "" : ".") + name;
    }

    public VBox toBox() {
        VBox code = new VBox();
        code.add((Box)new TextBox("package %s;", new Object[]{this.packageName}));
        code.add();
        List formattedImports = JavaCodeUtils.formatImports(this.imports, (String)this.packageName);
        for (String imp : formattedImports) {
            code.add(imp);
        }
        if (!formattedImports.isEmpty()) {
            code.add();
        }
        code.add((Box)this.header);
        VBox indentedBody = new VBox(4);
        indentedBody.add((Box)this.body);
        code.add((Box)indentedBody);
        code.add("}");
        return code;
    }

    public CharSequence getCharContent() {
        return this.toBox().toBuilder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaCodeFile)) {
            return false;
        }
        JavaCodeFile other = (JavaCodeFile)((Object)obj);
        return this.absClassName.equals(other.absClassName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() ^ this.absClassName.hashCode();
    }
}

