/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.ecore.delegates.DelegateContext;
import org.eclipse.epsilon.ecore.delegates.DelegateUri;
import org.eclipse.epsilon.ecore.delegates.EpsilonDelegateContext;
import org.eclipse.epsilon.ecore.delegates.execution.EvlConstraint;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateResourceAdapter;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.parse.EvlLexer;
import org.eclipse.epsilon.evl.parse.EvlParser;

public class EvlDelegateContext
extends EpsilonDelegateContext<EvlModule, Optional<UnsatisfiedConstraint>>
implements DelegateContext {
    public EvlDelegateContext(DelegateUri delegateURI, EPackage ePackage, DelegateResourceAdapter delegateRA) {
        super(delegateURI, ePackage, delegateRA, new EvlModule(), "evlModule");
    }

    @Override
    protected EpsilonParser createParser(TokenStream stream) {
        return new EvlParser(stream);
    }

    protected EvlLexer createLexer(ANTLRInputStream inputStream) throws IOException {
        return new EvlLexer((CharStream)inputStream);
    }

    protected EvlConstraint program(List<ParseProblem> parseProblems) {
        if (((EvlModule)this.module).getDeclaredConstraintContexts().isEmpty()) {
            return this.program().error(new IllegalStateException("Error parsing EVL, context is malformed."));
        }
        ConstraintContext contexts = (ConstraintContext)((EvlModule)this.module).getDeclaredConstraintContexts().get(0);
        if (contexts.getConstraints().isEmpty()) {
            return this.program().error(new IllegalStateException("Error parsing EVL, constraint is malformed."));
        }
        return new EvlConstraint((Constraint)contexts.getConstraints().get(0), parseProblems, ((EvlModule)this.module).getContext());
    }

    @Override
    protected void preParse() {
        ((EvlModule)this.module).getDeclaredConstraintContexts().clear();
    }

    protected EvlConstraint program() {
        return new EvlConstraint();
    }

    @Override
    protected void createAst(AST cst) {
        if (cst == null) {
            return;
        }
        ModuleElement moduleElement = ((EvlModule)this.module).adapt(cst, null);
        if (moduleElement != null) {
            moduleElement.setUri(cst.getUri());
            moduleElement.setModule(cst.getModule());
            moduleElement.setRegion(cst.getRegion());
            moduleElement.build(cst, cst.getModule());
        }
    }
}

