/*******************************************************************************
 * Copyright (c) 2009 The University of York.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Louis Rose - initial API and implementation
 ******************************************************************************
 *
 * $Id$
 */
package org.eclipse.epsilon.flock.execution.exceptions;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class FlockRuntimeException extends EolRuntimeException {

	// Generated by Eclipse
	private static final long serialVersionUID = -3550145829402258002L;

	protected FlockRuntimeException(String message) {
		super(message);
	}
	
	public FlockRuntimeException(Throwable cause) {
		this(cause.getMessage(), cause);
	}
	
	public FlockRuntimeException(String message, Throwable cause) {
		super(message);
		initCause(cause);
	}
	
	@Override
	public String toString() {
		final String cause = (getCause() == null ? "" : "\n" + getCause().toString()); 
		return super.toString() + cause;
	}
}
