/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.authn.oauth.RsaSha1PrivateKeyHelper;
import com.google.gdata.util.common.util.Base64;
import com.google.gdata.util.common.util.Base64DecoderException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;

public class OAuthRsaSha1Signer
implements OAuthSigner {
    PrivateKey privateKey;

    public OAuthRsaSha1Signer() {
    }

    public OAuthRsaSha1Signer(PrivateKey privateKey) throws OAuthException {
        this.setPrivateKey(privateKey);
    }

    public OAuthRsaSha1Signer(String privateKeyString) throws OAuthException {
        if (privateKeyString == null) {
            throw new OAuthException("Private key string cannot be null");
        }
        if (privateKeyString.length() == 0) {
            throw new OAuthException("Private key string cannot be empty");
        }
        try {
            this.setPrivateKey(RsaSha1PrivateKeyHelper.getPrivateKey(privateKeyString));
        }
        catch (Base64DecoderException e) {
            throw new OAuthException("Invalid private key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthException("Invalid private key", e);
        }
        catch (InvalidKeySpecException e) {
            throw new OAuthException("Invalid private key", e);
        }
    }

    public OAuthRsaSha1Signer(byte[] privateKeyBytes) throws OAuthException {
        if (privateKeyBytes == null) {
            throw new OAuthException("Private key bytes cannot be null");
        }
        if (privateKeyBytes.length == 0) {
            throw new OAuthException("Private key bytes cannot be empty");
        }
        try {
            this.setPrivateKey(RsaSha1PrivateKeyHelper.getPrivateKey(privateKeyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthException("Invalid private key", e);
        }
        catch (InvalidKeySpecException e) {
            throw new OAuthException("Invalid private key", e);
        }
    }

    public void setPrivateKey(PrivateKey privateKey) throws OAuthException {
        if (privateKey == null) {
            throw new OAuthException("Private key cannot be null");
        }
        this.privateKey = privateKey;
    }

    public String getSignature(String baseString, OAuthParameters oauthParameters) throws OAuthException {
        if (this.privateKey == null) {
            throw new OAuthException("Private key cannot be null");
        }
        try {
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(this.privateKey);
            signer.update(baseString.getBytes("UTF-8"));
            return Base64.encode(signer.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthException("Error generating signature", e);
        }
        catch (InvalidKeyException e) {
            throw new OAuthException("Error generating signature", e);
        }
        catch (SignatureException e) {
            throw new OAuthException("Error generating signature", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException("Error generating signature", e);
        }
    }

    public String getSignatureMethod() {
        return "RSA-SHA1";
    }
}

