/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.lang.ref.Reference;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.security.SecureFileStore;
import org.h2.store.DataHandler;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.util.ByteUtils;
import org.h2.util.TempFileDeleter;

public class FileStore {
    public static final int HEADER_LENGTH = 48;
    protected static final byte[] EMPTY = new byte[16384];
    protected String name;
    protected DataHandler handler;
    private FileObject file;
    private long filePos;
    private long fileLength;
    private Reference<?> autoDeleteReference;
    private boolean checkedWriting = true;
    private boolean synchronousMode;
    private String mode;
    private TempFileDeleter tempFileDeleter;
    private boolean textMode;

    protected FileStore(DataHandler dataHandler, String string, String string2) throws SQLException {
        FileSystem fileSystem = FileSystem.getInstance(string);
        this.handler = dataHandler;
        this.name = string;
        this.mode = string2;
        if (dataHandler != null) {
            this.tempFileDeleter = dataHandler.getTempFileDeleter();
        }
        try {
            fileSystem.createDirs(string);
            if (fileSystem.exists(string) && !fileSystem.canWrite(string)) {
                this.mode = string2 = "r";
            }
            this.file = fileSystem.openFileObject(string, string2);
            if (string2.length() > 2) {
                this.synchronousMode = true;
            }
            this.fileLength = this.file.length();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "name: " + string + " mode: " + string2);
        }
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2) throws SQLException {
        return FileStore.open(dataHandler, string, string2, null, null, 0);
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, String string3, byte[] byArray) throws SQLException {
        return FileStore.open(dataHandler, string, string2, string3, byArray, 1024);
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, String string3, byte[] byArray, int n) throws SQLException {
        FileStore fileStore = string3 == null ? new FileStore(dataHandler, string, string2) : new SecureFileStore(dataHandler, string, string2, string3, byArray, n);
        return fileStore;
    }

    protected byte[] generateSalt() {
        return Constants.MAGIC_FILE_HEADER.getBytes();
    }

    protected void initKey(byte[] byArray) {
    }

    public void setCheckedWriting(boolean bl) {
        this.checkedWriting = bl;
    }

    private void checkWritingAllowed() throws SQLException {
        if (this.handler != null && this.checkedWriting) {
            this.handler.checkWritingAllowed();
        }
    }

    private void checkPowerOff() throws SQLException {
        if (this.handler != null) {
            this.handler.checkPowerOff();
        }
    }

    public void init() throws SQLException {
        int n = 16;
        byte[] byArray = Constants.MAGIC_FILE_HEADER.getBytes();
        if (this.length() < 48L) {
            this.checkedWriting = false;
            this.writeDirect(byArray, 0, n);
            byte[] byArray2 = this.generateSalt();
            this.writeDirect(byArray2, 0, n);
            this.initKey(byArray2);
            this.write(byArray, 0, n);
            this.checkedWriting = true;
        } else {
            this.seek(0L);
            byte[] byArray3 = new byte[n];
            this.readFullyDirect(byArray3, 0, n);
            if (byArray3[10] == 84) {
                byArray3[10] = 66;
                this.textMode = true;
            }
            if (ByteUtils.compareNotNull(byArray3, byArray) != 0) {
                throw Message.getSQLException(90048, this.name);
            }
            byte[] byArray4 = new byte[n];
            this.readFullyDirect(byArray4, 0, n);
            this.initKey(byArray4);
            this.readFully(byArray3, 0, 16);
            if (this.textMode) {
                byArray3[10] = 66;
            }
            if (ByteUtils.compareNotNull(byArray3, byArray) != 0) {
                throw Message.getSQLException(90049, this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.file != null) {
            try {
                FileStore.trace("close", this.name, this.file);
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
    }

    public void closeSilently() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeAndDeleteSilently() {
        if (this.file != null) {
            this.closeSilently();
            this.tempFileDeleter.updateAutoDelete(this.autoDeleteReference);
            this.tempFileDeleter.deleteFile(this.autoDeleteReference, this.name);
            this.name = null;
        }
    }

    protected void readFullyDirect(byte[] byArray, int n, int n2) throws SQLException {
        this.readFully(byArray, n, n2);
    }

    public void readFully(byte[] byArray, int n, int n2) throws SQLException {
        if (SysProperties.CHECK && (n2 < 0 || n2 % 16 != 0)) {
            Message.throwInternalError("unaligned write " + this.name + " len " + n2);
        }
        this.checkPowerOff();
        try {
            this.file.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.name);
        }
        this.filePos += (long)n2;
    }

    public void seek(long l) throws SQLException {
        if (SysProperties.CHECK && l % 16L != 0L) {
            Message.throwInternalError("unaligned seek " + this.name + " pos " + l);
        }
        try {
            if (l != this.filePos) {
                this.file.seek(l);
                this.filePos = l;
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.name);
        }
    }

    protected void writeDirect(byte[] byArray, int n, int n2) throws SQLException {
        this.write(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        if (SysProperties.CHECK && (n2 < 0 || n2 % 16 != 0)) {
            Message.throwInternalError("unaligned write " + this.name + " len " + n2);
        }
        this.checkWritingAllowed();
        this.checkPowerOff();
        try {
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (this.freeUpDiskSpace()) {
                try {
                    this.file.write(byArray, n, n2);
                }
                catch (IOException iOException2) {
                    throw Message.convertIOException(iOException2, this.name);
                }
            }
            throw Message.convertIOException(iOException, this.name);
        }
        this.filePos += (long)n2;
        this.fileLength = Math.max(this.filePos, this.fileLength);
    }

    private boolean freeUpDiskSpace() throws SQLException {
        if (this.handler == null) {
            return false;
        }
        this.handler.freeUpDiskSpace();
        return true;
    }

    private void extendByWriting(long l) throws IOException {
        int n;
        long l2 = this.filePos;
        this.file.seek(this.fileLength);
        byte[] byArray = EMPTY;
        while ((n = (int)Math.min(l - this.fileLength, (long)EMPTY.length)) > 0) {
            this.file.write(byArray, 0, n);
            this.fileLength += (long)n;
        }
        this.file.seek(l2);
    }

    public void setLength(long l) throws SQLException {
        if (SysProperties.CHECK && l % 16L != 0L) {
            Message.throwInternalError("unaligned setLength " + this.name + " pos " + l);
        }
        this.checkPowerOff();
        this.checkWritingAllowed();
        try {
            if (this.synchronousMode && l > this.fileLength) {
                this.extendByWriting(l);
            } else {
                this.file.setFileLength(l);
            }
            this.fileLength = l;
        }
        catch (IOException iOException) {
            if (l > this.fileLength && this.freeUpDiskSpace()) {
                try {
                    this.file.setFileLength(l);
                }
                catch (IOException iOException2) {
                    throw Message.convertIOException(iOException2, this.name);
                }
            }
            throw Message.convertIOException(iOException, this.name);
        }
    }

    public long length() throws SQLException {
        try {
            long l = this.fileLength;
            if (SysProperties.CHECK2 && (l = this.file.length()) != this.fileLength) {
                Message.throwInternalError("file " + this.name + " length " + l + " expected " + this.fileLength);
            }
            if (SysProperties.CHECK2 && l % 16L != 0L) {
                long l2 = l + 16L - l % 16L;
                this.file.setFileLength(l2);
                this.fileLength = l2;
                Message.throwInternalError("unaligned file length " + this.name + " len " + l);
            }
            return l;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.name);
        }
    }

    public long getFilePointer() throws SQLException {
        if (SysProperties.CHECK2) {
            try {
                if (this.file.getFilePointer() != this.filePos) {
                    Message.throwInternalError();
                }
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.name);
            }
        }
        return this.filePos;
    }

    public void sync() {
        block2: {
            try {
                this.file.sync();
            }
            catch (IOException iOException) {
                Trace trace = this.handler.getTrace();
                if (trace == null) break block2;
                trace.error("Sync failed", iOException);
            }
        }
    }

    public void autoDelete() {
        if (this.autoDeleteReference == null) {
            this.autoDeleteReference = this.tempFileDeleter.addFile(this.name, this);
        } else {
            this.tempFileDeleter.updateAutoDelete(this.autoDeleteReference);
        }
    }

    public void stopAutoDelete() {
        this.tempFileDeleter.stopAutoDelete(this.autoDeleteReference, this.name);
        this.autoDeleteReference = null;
    }

    public boolean isEncrypted() {
        return false;
    }

    public void closeFile() throws IOException {
        this.file.close();
        this.file = null;
    }

    public void openFile() throws IOException {
        if (this.file == null) {
            this.file = FileSystem.getInstance(this.name).openFileObject(this.name, this.mode);
            this.file.seek(this.filePos);
        }
    }

    private static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileStore." + string + " " + string2 + " " + object);
        }
    }

    public boolean isTextMode() {
        return this.textMode;
    }
}

