/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.commons.csv.Assertions;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Lexer;
import org.apache.commons.csv.Token;

public final class CSVParser
implements Iterable<CSVRecord>,
Closeable {
    private final CSVFormat format;
    private final Map<String, Integer> headerMap;
    private final List<String> headerNames;
    private final Lexer lexer;
    private final CSVRecordIterator csvRecordIterator;
    private final List<String> recordList = new ArrayList<String>();
    private long recordNumber;
    private final long characterOffset;
    private final Token reusableToken = new Token();

    public static CSVParser parse(File file, Charset charset, CSVFormat format) throws IOException {
        Assertions.notNull(file, "file");
        Assertions.notNull(format, "format");
        return new CSVParser(new InputStreamReader((InputStream)new FileInputStream(file), charset), format);
    }

    public static CSVParser parse(InputStream inputStream, Charset charset, CSVFormat format) throws IOException {
        Assertions.notNull(inputStream, "inputStream");
        Assertions.notNull(format, "format");
        return CSVParser.parse(new InputStreamReader(inputStream, charset), format);
    }

    public static CSVParser parse(Path path, Charset charset, CSVFormat format) throws IOException {
        Assertions.notNull(path, "path");
        Assertions.notNull(format, "format");
        return CSVParser.parse(Files.newInputStream(path, new OpenOption[0]), charset, format);
    }

    public static CSVParser parse(Reader reader, CSVFormat format) throws IOException {
        return new CSVParser(reader, format);
    }

    public static CSVParser parse(String string, CSVFormat format) throws IOException {
        Assertions.notNull(string, "string");
        Assertions.notNull(format, "format");
        return new CSVParser(new StringReader(string), format);
    }

    public static CSVParser parse(URL url, Charset charset, CSVFormat format) throws IOException {
        Assertions.notNull(url, "url");
        Assertions.notNull(charset, "charset");
        Assertions.notNull(format, "format");
        return new CSVParser(new InputStreamReader(url.openStream(), charset), format);
    }

    public CSVParser(Reader reader, CSVFormat format) throws IOException {
        this(reader, format, 0L, 1L);
    }

    public CSVParser(Reader reader, CSVFormat format, long characterOffset, long recordNumber) throws IOException {
        Assertions.notNull(reader, "reader");
        Assertions.notNull(format, "format");
        this.format = format;
        this.lexer = new Lexer(format, new ExtendedBufferedReader(reader));
        this.csvRecordIterator = new CSVRecordIterator();
        Headers headers = this.createHeaders();
        this.headerMap = headers.headerMap;
        this.headerNames = headers.headerNames;
        this.characterOffset = characterOffset;
        this.recordNumber = recordNumber - 1L;
    }

    private void addRecordValue(boolean lastRecord) {
        String inputClean;
        String input = this.reusableToken.content.toString();
        String string = inputClean = this.format.getTrim() ? input.trim() : input;
        if (lastRecord && inputClean.isEmpty() && this.format.getTrailingDelimiter()) {
            return;
        }
        String nullString = this.format.getNullString();
        this.recordList.add(inputClean.equals(nullString) ? null : inputClean);
    }

    @Override
    public void close() throws IOException {
        if (this.lexer != null) {
            this.lexer.close();
        }
    }

    private Map<String, Integer> createEmptyHeaderMap() {
        return this.format.getIgnoreHeaderCase() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
    }

    private Headers createHeaders() throws IOException {
        Map<String, Integer> hdrMap = null;
        List<String> headerNames = null;
        Object[] formatHeader = this.format.getHeader();
        if (formatHeader != null) {
            hdrMap = this.createEmptyHeaderMap();
            Object[] headerRecord = null;
            if (formatHeader.length == 0) {
                CSVRecord nextRecord = this.nextRecord();
                if (nextRecord != null) {
                    headerRecord = nextRecord.values();
                }
            } else {
                if (this.format.getSkipHeaderRecord()) {
                    this.nextRecord();
                }
                headerRecord = formatHeader;
            }
            if (headerRecord != null) {
                for (int i = 0; i < headerRecord.length; ++i) {
                    boolean containsHeader;
                    boolean emptyHeader;
                    String header = headerRecord[i];
                    boolean bl = emptyHeader = header == null || header.trim().isEmpty();
                    if (emptyHeader && !this.format.getAllowMissingColumnNames()) {
                        throw new IllegalArgumentException("A header name is missing in " + Arrays.toString(headerRecord));
                    }
                    boolean bl2 = containsHeader = header != null && hdrMap.containsKey(header);
                    if (containsHeader && !emptyHeader && !this.format.getAllowDuplicateHeaderNames()) {
                        throw new IllegalArgumentException(String.format("The header contains a duplicate name: \"%s\" in %s. If this is valid then use CSVFormat.withAllowDuplicateHeaderNames().", header, Arrays.toString(headerRecord)));
                    }
                    if (header == null) continue;
                    hdrMap.put(header, i);
                    if (headerNames == null) {
                        headerNames = new ArrayList<String>(headerRecord.length);
                    }
                    headerNames.add(header);
                }
            }
        }
        headerNames = headerNames == null ? Collections.emptyList() : Collections.unmodifiableList(headerNames);
        return new Headers(hdrMap, headerNames);
    }

    public long getCurrentLineNumber() {
        return this.lexer.getCurrentLineNumber();
    }

    public String getFirstEndOfLine() {
        return this.lexer.getFirstEol();
    }

    public Map<String, Integer> getHeaderMap() {
        if (this.headerMap == null) {
            return null;
        }
        Map<String, Integer> map = this.createEmptyHeaderMap();
        map.putAll(this.headerMap);
        return map;
    }

    Map<String, Integer> getHeaderMapRaw() {
        return this.headerMap;
    }

    public List<String> getHeaderNames() {
        return this.headerNames;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public List<CSVRecord> getRecords() throws IOException {
        CSVRecord rec;
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        while ((rec = this.nextRecord()) != null) {
            records.add(rec);
        }
        return records;
    }

    public boolean isClosed() {
        return this.lexer.isClosed();
    }

    @Override
    public Iterator<CSVRecord> iterator() {
        return this.csvRecordIterator;
    }

    CSVRecord nextRecord() throws IOException {
        CSVRecord result = null;
        this.recordList.clear();
        StringBuilder sb = null;
        long startCharPosition = this.lexer.getCharacterPosition() + this.characterOffset;
        block7: do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    this.addRecordValue(false);
                    break;
                }
                case EORECORD: {
                    this.addRecordValue(true);
                    break;
                }
                case EOF: {
                    if (!this.reusableToken.isReady) continue block7;
                    this.addRecordValue(true);
                    break;
                }
                case INVALID: {
                    throw new IOException("(line " + this.getCurrentLineNumber() + ") invalid parse sequence");
                }
                case COMMENT: {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append('\n');
                    }
                    sb.append((CharSequence)this.reusableToken.content);
                    this.reusableToken.type = Token.Type.TOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Token type: " + (Object)((Object)this.reusableToken.type));
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        if (!this.recordList.isEmpty()) {
            ++this.recordNumber;
            String comment = sb == null ? null : sb.toString();
            result = new CSVRecord(this, this.recordList.toArray(new String[this.recordList.size()]), comment, this.recordNumber, startCharPosition);
        }
        return result;
    }

    private static final class Headers {
        final Map<String, Integer> headerMap;
        final List<String> headerNames;

        Headers(Map<String, Integer> headerMap, List<String> headerNames) {
            this.headerMap = headerMap;
            this.headerNames = headerNames;
        }
    }

    class CSVRecordIterator
    implements Iterator<CSVRecord> {
        private CSVRecord current;

        CSVRecordIterator() {
        }

        private CSVRecord getNextRecord() {
            try {
                return CSVParser.this.nextRecord();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2.getClass().getSimpleName() + " reading next record: " + e2.toString(), e2);
            }
        }

        @Override
        public boolean hasNext() {
            if (CSVParser.this.isClosed()) {
                return false;
            }
            if (this.current == null) {
                this.current = this.getNextRecord();
            }
            return this.current != null;
        }

        @Override
        public CSVRecord next() {
            if (CSVParser.this.isClosed()) {
                throw new NoSuchElementException("CSVParser has been closed");
            }
            CSVRecord next = this.current;
            this.current = null;
            if (next == null && (next = this.getNextRecord()) == null) {
                throw new NoSuchElementException("No more CSV records available");
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

