/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.util;

import java.lang.reflect.Field;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.common.model.util.ESNotificationInfo;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.util.ESNotificationInfoImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationInfo
implements Notification,
APIDelegate<ESNotificationInfo> {
    private final Notification notification;
    private boolean valid;
    private String validationMessage;
    private ESNotificationInfo apiImpl;

    public NotificationInfo(Notification n) {
        this.notification = n;
        NotificationValidator.getInstance().validate(this);
    }

    public EStructuralFeature getStructuralFeature() {
        if (this.getFeature() instanceof EStructuralFeature) {
            return (EStructuralFeature)this.getFeature();
        }
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    protected void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public boolean isAttributeNotification() {
        return this.notification.getFeature() instanceof EAttribute;
    }

    public boolean isReferenceNotification() {
        return this.notification.getFeature() instanceof EReference;
    }

    public EAttribute getAttribute() {
        if (this.isAttributeNotification()) {
            return (EAttribute)this.notification.getFeature();
        }
        return null;
    }

    public EReference getReference() {
        if (this.isReferenceNotification()) {
            return (EReference)this.notification.getFeature();
        }
        return null;
    }

    public boolean isTransient() {
        return this.isReferenceNotification() && this.getReference().isTransient() || this.isAttributeNotification() && this.getAttribute().isTransient();
    }

    public boolean isAddEvent() {
        return this.getEventType() == 3;
    }

    public boolean isRemoveEvent() {
        return this.getEventType() == 4;
    }

    public boolean isSetEvent() {
        return this.getEventType() == 1;
    }

    public boolean isAddManyEvent() {
        return this.getEventType() == 5;
    }

    public boolean isRemoveManyEvent() {
        return this.getEventType() == 6;
    }

    public boolean isMoveEvent() {
        return this.getEventType() == 7;
    }

    public boolean hasNext() {
        Notification nextNotification;
        block9: {
            EReference eReference;
            block8: {
                if (!(this.notification instanceof NotificationImpl)) {
                    return false;
                }
                Field declaredField = NotificationImpl.class.getDeclaredField("next");
                declaredField.setAccessible(true);
                Object object = declaredField.get(this.notification);
                nextNotification = (Notification)object;
                if (nextNotification != null) break block8;
                return false;
            }
            Object feature = nextNotification.getFeature();
            if (!(feature instanceof EReference) || !(eReference = (EReference)feature).isTransient()) break block9;
            return false;
        }
        try {
            if (nextNotification.getNotifier() instanceof Project) {
                NotificationInfo nextNextInfo = new NotificationInfo(nextNotification);
                return nextNextInfo.hasNext();
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    public int getEventType() {
        return this.notification.getEventType();
    }

    public Object getFeature() {
        return this.notification.getFeature();
    }

    public int getFeatureID(Class<?> expectedClass) {
        return this.notification.getFeatureID(expectedClass);
    }

    public boolean getNewBooleanValue() {
        return this.notification.getNewBooleanValue();
    }

    public byte getNewByteValue() {
        return this.notification.getNewByteValue();
    }

    public char getNewCharValue() {
        return this.notification.getNewCharValue();
    }

    public double getNewDoubleValue() {
        return this.notification.getNewDoubleValue();
    }

    public float getNewFloatValue() {
        return this.notification.getNewFloatValue();
    }

    public int getNewIntValue() {
        return this.notification.getNewIntValue();
    }

    public long getNewLongValue() {
        return this.notification.getNewLongValue();
    }

    public short getNewShortValue() {
        return this.notification.getNewShortValue();
    }

    public String getNewStringValue() {
        return this.notification.getNewStringValue();
    }

    public Object getNewValue() {
        return this.notification.getNewValue();
    }

    public EObject getNewModelElementValue() {
        return (EObject)this.notification.getNewValue();
    }

    public Object getNotifier() {
        return this.notification.getNotifier();
    }

    public boolean getOldBooleanValue() {
        return this.notification.getOldBooleanValue();
    }

    public byte getOldByteValue() {
        return this.notification.getOldByteValue();
    }

    public char getOldCharValue() {
        return this.notification.getOldCharValue();
    }

    public double getOldDoubleValue() {
        return this.notification.getOldDoubleValue();
    }

    public float getOldFloatValue() {
        return this.notification.getOldFloatValue();
    }

    public int getOldIntValue() {
        return this.notification.getOldIntValue();
    }

    public long getOldLongValue() {
        return this.notification.getOldLongValue();
    }

    public short getOldShortValue() {
        return this.notification.getOldShortValue();
    }

    public String getOldStringValue() {
        return this.notification.getOldStringValue();
    }

    public Object getOldValue() {
        return this.notification.getOldValue();
    }

    public EObject getOldModelElementValue() {
        return (EObject)this.notification.getOldValue();
    }

    public int getPosition() {
        return this.notification.getPosition();
    }

    public boolean isReset() {
        return this.notification.isReset();
    }

    public boolean isTouch() {
        return this.notification.isTouch();
    }

    public boolean merge(Notification notification) {
        return notification.merge(notification);
    }

    public boolean wasUnset() {
        return this.getStructuralFeature().isUnsettable() && !this.notification.wasSet();
    }

    public String toString() {
        return this.notification.toString();
    }

    public EObject getNotifierModelElement() {
        return (EObject)this.notification.getNotifier();
    }

    public String getDebugString() {
        StringBuilder sb = new StringBuilder();
        if (this.isAddEvent()) {
            sb.append("ADD");
        } else if (this.isSetEvent()) {
            sb.append("SET");
        } else if (this.isAddManyEvent()) {
            sb.append("ADD_MANY");
        } else if (this.isRemoveEvent()) {
            sb.append("REMOVE");
        } else if (this.isRemoveManyEvent()) {
            sb.append("REMOVE_MANY");
        } else if (this.isMoveEvent()) {
            sb.append("MOVE");
        } else {
            sb.append(this.getEventType());
        }
        sb.append(" val: " + this.getValidationMessage());
        EObject n = (EObject)this.notification.getNotifier();
        sb.append(" / on: " + this.extractName(n));
        sb.append(".");
        if (this.isAttributeNotification()) {
            sb.append(this.getAttribute().getName());
        } else if (this.isReferenceNotification()) {
            sb.append(this.getReference().getName());
        }
        sb.append(" / old: ");
        if (this.getOldValue() instanceof EObject) {
            sb.append(this.extractName((EObject)this.getOldValue()));
        } else {
            sb.append(this.getOldValue());
        }
        sb.append(" / new: ");
        if (this.getNewValue() instanceof EObject) {
            sb.append(this.extractName((EObject)this.getNewValue()));
        } else {
            sb.append(this.getNewValue());
        }
        return sb.toString();
    }

    private String extractName(EObject o) {
        if (o == null) {
            return null;
        }
        EStructuralFeature f = o.eClass().getEStructuralFeature("name");
        if (f != null && o.eGet(f) != null) {
            return "'" + (String)o.eGet(f) + "'";
        }
        return o.eClass().getName();
    }

    public Class<? extends Notification> getNotificationType() {
        return this.notification.getClass();
    }

    public ESNotificationInfo toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESNotificationInfo createAPI() {
        return new ESNotificationInfoImpl(this);
    }

    public boolean wasSet() {
        return this.notification.wasSet();
    }
}

