/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.scm;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.ui.common.EClassFilter;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.FilteredOperationsResult;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterOperations {
    private final ModelElementIdToEObjectMapping idToEObjectMapping;
    private final Class<? extends EObject> ignoredClass;

    public FilterOperations(ModelElementIdToEObjectMapping idToEObjectMapping) {
        this.idToEObjectMapping = idToEObjectMapping;
        this.ignoredClass = null;
    }

    public FilterOperations(ModelElementIdToEObjectMapping idToEObjectMapping, Class<? extends EObject> ignoredClass) {
        this.idToEObjectMapping = idToEObjectMapping;
        this.ignoredClass = ignoredClass;
    }

    public FilteredOperationsResult filter(Object[] input) {
        FilteredOperationsResult result = new FilteredOperationsResult();
        Object[] objectArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.ignoredClass == null || !this.ignoredClass.isInstance(object)) {
                if (object instanceof AbstractOperation) {
                    AbstractOperation operation = (AbstractOperation)object;
                    if (this.eClassFilterEnabled() && EClassFilter.INSTANCE.involvesOnlyFilteredEClasses(this.idToEObjectMapping, operation)) {
                        result.addFilteredOperation(operation);
                    } else {
                        result.addNonFiltered(operation);
                    }
                } else {
                    result.addNonFiltered(object);
                }
            }
            ++n2;
        }
        return result;
    }

    private boolean eClassFilterEnabled() {
        return EClassFilter.INSTANCE.isEnabled() && this.idToEObjectMapping != null;
    }
}

