/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.changes;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.common.OperationCustomLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.Messages;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;

public class DefaultOperationLabelProvider
implements OperationCustomLabelProvider {
    protected static final String UNKOWN_ELEMENT = Messages.DefaultOperationLabelProvider_UnknownElement;
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private ComposedAdapterFactory adapterFactory;
    private boolean isDisposed;

    public DefaultOperationLabelProvider() {
        this.init();
    }

    protected void init() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        }
        if (this.adapterFactoryLabelProvider == null) {
            this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        }
        this.isDisposed = false;
    }

    public String getDescription(AbstractOperation operation) {
        CompositeOperation compositeOperation;
        if (operation instanceof CompositeOperation && (compositeOperation = (CompositeOperation)operation).getMainOperation() != null) {
            return this.getDescription(compositeOperation.getMainOperation());
        }
        if (this.isDisposed()) {
            this.init();
        }
        return this.adapterFactoryLabelProvider.getText((Object)operation);
    }

    public Object getImage(AbstractOperation operation) {
        if (this.isDisposed()) {
            this.init();
        }
        return this.adapterFactoryLabelProvider.getImage((Object)operation);
    }

    public OperationCustomLabelProvider.CanRender canRender(AbstractOperation operation) {
        return OperationCustomLabelProvider.CanRender.Yes;
    }

    public String getModelElementName(EObject modelElement) {
        if (this.isDisposed()) {
            this.init();
        }
        if (modelElement == null) {
            return UNKOWN_ELEMENT;
        }
        return this.trim(this.adapterFactoryLabelProvider.getText((Object)modelElement));
    }

    private String trim(Object object) {
        String string = object.toString();
        String result = string.trim();
        if (result.length() == 0) {
            return Messages.DefaultOperationLabelProvider_EmptyName;
        }
        return result;
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
            this.adapterFactory = null;
        }
        if (this.adapterFactoryLabelProvider != null) {
            this.adapterFactoryLabelProvider.dispose();
            this.adapterFactoryLabelProvider = null;
        }
        this.isDisposed = true;
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    protected AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        return this.adapterFactoryLabelProvider;
    }
}

