/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.connectionmanager.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcSun15HttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.client.model.exceptions.CertificateStoreException;
import org.eclipse.emf.emfstore.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.util.EObjectTypeFactory;
import org.eclipse.emf.emfstore.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcClientManager {
    private String serverInterface;
    private XmlRpcClient client;

    public XmlRpcClientManager(String serverInterface) {
        this.serverInterface = serverInterface;
    }

    public void initConnection(ServerInfo serverInfo) throws ConnectionException {
        try {
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(this.createURL(serverInfo));
            config.setEnabledForExceptions(true);
            config.setEnabledForExtensions(true);
            config.setConnectionTimeout(Configuration.getXMLRPCConnectionTimeout());
            config.setReplyTimeout(Configuration.getXMLRPCReplyTimeout());
            this.client = new XmlRpcClient();
            this.client.setTypeFactory((TypeFactory)new EObjectTypeFactory((XmlRpcController)this.client));
            XmlRpcSun15HttpTransportFactory factory = new XmlRpcSun15HttpTransportFactory(this.client);
            try {
                factory.setSSLSocketFactory(KeyStoreManager.getInstance().getSSLContext().getSocketFactory());
            }
            catch (CertificateStoreException e) {
                throw new ConnectionException("Couldn't load certificate", (Throwable)e);
            }
            this.client.setTransportFactory((XmlRpcTransportFactory)factory);
            this.client.setConfig((XmlRpcClientConfig)config);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException("Malformed Url or Port", (Throwable)e);
        }
    }

    private URL createURL(ServerInfo serverInfo) throws MalformedURLException {
        this.checkUrl(serverInfo.getUrl());
        return new URL("https", serverInfo.getUrl(), serverInfo.getPort(), "xmlrpc");
    }

    private void checkUrl(String url) throws MalformedURLException {
        if (!(url == null || url.equals("") || url.contains(":") || url.contains("/"))) {
            return;
        }
        throw new MalformedURLException();
    }

    public <T> T callWithResult(String methodName, Class<T> returnType, Object ... parameters) throws EmfStoreException {
        return this.executeCall(methodName, returnType, parameters);
    }

    public <T> List<T> callWithListResult(String methodName, Class<T> returnType, Object ... parameters) throws EmfStoreException {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] callResult = this.executeCall(methodName, Object[].class, parameters);
        if (callResult == null) {
            return result;
        }
        Object[] objectArray = callResult;
        int n = callResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add(obj);
            ++n2;
        }
        return result;
    }

    public void call(String methodName, Object ... parameters) throws EmfStoreException {
        this.executeCall(methodName, null, parameters);
    }

    private <T> T executeCall(String methodName, Class<T> returnType, Object[] params) throws EmfStoreException {
        if (this.client == null) {
            throw new ConnectionException("Server could not be reached.");
        }
        try {
            return (T)this.client.execute(String.valueOf(this.serverInterface) + "." + methodName, params);
        }
        catch (XmlRpcException e) {
            if (e.getCause() instanceof EmfStoreException) {
                throw (EmfStoreException)e.getCause();
            }
            if (e.linkedException instanceof SAXException && ((SAXException)e.linkedException).getException() instanceof SerializationException) {
                SerializationException serialE = (SerializationException)((SAXException)e.linkedException).getException();
                throw new org.eclipse.emf.emfstore.server.exceptions.SerializationException((Throwable)serialE);
            }
            throw new ConnectionException("Server could not be reached.", (Throwable)e);
        }
    }
}

