/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.scm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.jface.viewers.ITreeContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCMContentProvider
extends AdapterFactoryContentProvider
implements ITreeContentProvider {
    private boolean showRootNodes = true;
    private boolean reverseNodes = true;

    public SCMContentProvider() {
        super((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }

    public void setReverseNodes(boolean reverseNodes) {
        this.reverseNodes = reverseNodes;
    }

    public boolean isReverseNodes() {
        return this.reverseNodes;
    }

    public Object[] getElements(Object object) {
        if (object instanceof List && this.showRootNodes) {
            return ((List)object).toArray();
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return list.toArray();
            }
            ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>(list.size());
            if (this.isListOf(list, HistoryInfo.class)) {
                for (HistoryInfo info : list) {
                    if (info.getChangePackage() == null) continue;
                    result.addAll(this.getReversedOperations(info.getChangePackage()));
                }
            } else {
                for (ChangePackage changePackage : list) {
                    result.addAll(this.getReversedOperations(changePackage));
                }
            }
            return result.toArray();
        }
        if (object instanceof EObject) {
            return new Object[]{object};
        }
        return super.getElements(object);
    }

    private List<AbstractOperation> getReversedOperations(ChangePackage changePackage) {
        ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>((Collection<AbstractOperation>)changePackage.getOperations());
        Collections.reverse(ops);
        return ops;
    }

    private boolean isListOf(List<?> list, Class<? extends EObject> clazz) {
        Object firstElement = list.get(0);
        return clazz.isInstance(firstElement);
    }

    private Object[] filter(Object[] input, Class<? extends EObject> clazz) {
        ArrayList<Object> result = new ArrayList<Object>(input.length);
        Object[] objectArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!clazz.isInstance(object)) {
                result.add(object);
            }
            ++n2;
        }
        return result.toArray();
    }

    public Object[] getChildren(Object object) {
        if (object instanceof HistoryInfo) {
            HistoryInfo historyInfo = (HistoryInfo)object;
            return this.getChildren(historyInfo.getChangePackage());
        }
        if (object instanceof ChangePackage) {
            return this.filter(super.getChildren(object), LogMessage.class);
        }
        return super.getChildren(object);
    }

    public boolean isShowRootNodes() {
        return this.showRootNodes;
    }

    public void setShowRootNodes(boolean showRootNodes) {
        this.showRootNodes = showRootNodes;
    }
}

