/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.util;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.ui.Activator;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionConfig;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecisionUtil {
    private static final AdapterFactoryLabelProvider ADAPTER_FACTORY_LABEL_PROVIDER = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    private static FontRegistry fontRegistry;

    private DecisionUtil() {
    }

    public static Image getImage(String path) {
        return DecisionUtil.getImageDescriptor(path).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        String key = path;
        ImageDescriptor regImage = JFaceResources.getImageRegistry().getDescriptor(key);
        if (regImage == null) {
            regImage = Activator.getImageDescriptor("icons/merge/" + path);
            JFaceResources.getImageRegistry().put(key, regImage);
        }
        return regImage;
    }

    public static String cutString(String str, int length, boolean addPoints) {
        if (str == null) {
            return "";
        }
        if (str.length() > length) {
            str = str.substring(0, length);
            if (addPoints) {
                str = String.valueOf(str) + "...";
            }
            return str;
        }
        return str;
    }

    public static String stripNewLine(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("\n\r|\r\n|\n \r|\r \n|\n|\r", " ");
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry(Display.getCurrent());
            DecisionConfig.initFonts(fontRegistry);
        }
        return fontRegistry;
    }

    public static ConflictOption getConflictOptionByType(List<ConflictOption> options, ConflictOption.OptionType type) {
        for (ConflictOption option : options) {
            if (!option.getType().equals((Object)type)) continue;
            return option;
        }
        return null;
    }

    public static boolean detailsNeeded(Conflict conflict) {
        if (!conflict.hasDetails()) {
            return false;
        }
        for (ConflictOption option : conflict.getOptions()) {
            if (!option.isDetailsProvider()) continue;
            if (option.getDetailProvider().startsWith("org.eclipse.emf.emfstore.client.ui.merge.widget.multiline")) {
                if (option.getOptionLabel().length() <= 50) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static String getLabel(Object obj, String unset) {
        return obj != null && obj.toString().length() > 1 ? obj.toString() : unset;
    }

    public static String getClassAndName(EObject modelElement) {
        if (modelElement == null) {
            return "";
        }
        String name = DecisionUtil.getAdapterFactory().getText((Object)modelElement);
        return String.valueOf(modelElement.eClass().getName()) + " \"" + name + "\"";
    }

    public static AdapterFactoryLabelProvider getAdapterFactory() {
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = ADAPTER_FACTORY_LABEL_PROVIDER;
        return adapterFactoryLabelProvider;
    }
}

