/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.options;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeTextOption
extends ConflictOption {
    private List<ConflictOption> list = new ArrayList<ConflictOption>();
    private String text;

    public MergeTextOption() {
        super("Select Edited/Merged Value", ConflictOption.OptionType.MergeText);
        this.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.multiline#editable");
    }

    public void add(ConflictOption option) {
        this.list.add(option);
    }

    @Override
    public String getFullOptionLabel() {
        String result = "";
        for (ConflictOption option : this.list) {
            result = String.valueOf(result) + " " + option.getFullOptionLabel();
        }
        return result;
    }

    public String getMyText() {
        ConflictOption option = DecisionUtil.getConflictOptionByType(this.list, ConflictOption.OptionType.MyOperation);
        return option == null ? "" : option.getFullOptionLabel();
    }

    public String getTheirString() {
        ConflictOption option = DecisionUtil.getConflictOptionByType(this.list, ConflictOption.OptionType.TheirOperation);
        return option == null ? "" : option.getFullOptionLabel();
    }

    @Override
    public List<AbstractOperation> getOperations() {
        if (this.text != null) {
            for (ConflictOption option : this.list) {
                AbstractOperation tmp;
                if (!option.getType().equals((Object)ConflictOption.OptionType.MyOperation) || option.getOperations().size() == 0 || !((tmp = option.getOperations().get(0)) instanceof AttributeOperation)) continue;
                option.getOperations().remove(0);
                AttributeOperation mergedOp = (AttributeOperation)ModelUtil.clone((EObject)tmp);
                mergedOp.setIdentifier(EcoreUtil.generateUUID());
                mergedOp.setNewValue((Object)this.text);
                option.getOperations().add(0, (AbstractOperation)mergedOp);
                return option.getOperations();
            }
        }
        return super.getOperations();
    }

    public void setMergedText(String text) {
        this.text = text;
    }

    public String getMergedText() {
        return this.text;
    }
}

