/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictContext;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionConflict
extends Conflict {
    public DeletionConflict(List<AbstractOperation> deletingOperation, List<AbstractOperation> deletedOperations, boolean meCausingDelete, DecisionManager decisionManager) {
        super(deletingOperation, deletedOperations, decisionManager, meCausingDelete, false);
        this.init();
    }

    @Override
    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getLeftOperation(), this.getTheirOperation());
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        String descriptionTxt = "";
        descriptionTxt = this.isLeftMy() ? "You have deleted the [modelelement]. This deletion conflicts with a change on the [firstother] element" + this.generateOthers() + ". Please choose an option." : "The [modelelement] was deleted on the repository which conflicts with the change on your [firstother]" + this.generateOthers() + ". Please choose an option.";
        description.setDescription(descriptionTxt);
        description.add("modelelement", this.getLeftOperation().getModelElementId());
        description.add("firstother", this.getRightOperation().getModelElementId());
        description.add("otherinvolved", this.generateOthers());
        description.setImage("delete.gif");
        return description;
    }

    private String generateOthers() {
        if (this.getRightOperations().size() > 1) {
            return " and " + (this.getRightOperations().size() - 1) + " other elements";
        }
        return "";
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (this.isLeftMy()) {
            myOption.setOptionLabel(this.deleteMsg());
            theirOption.setOptionLabel(this.keepMsg());
            theirOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.otherinvolved");
        } else {
            myOption.setOptionLabel(this.keepMsg());
            myOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.otherinvolved");
            theirOption.setOptionLabel(this.deleteMsg());
        }
        options.add(myOption);
        options.add(theirOption);
    }

    private String keepMsg() {
        EObject modelElement = this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId());
        String result = "Recover " + DecisionUtil.getClassAndName(modelElement);
        result = String.valueOf(result) + this.generateOthers();
        return result;
    }

    private String deleteMsg() {
        EObject modelElement = this.getDecisionManager().getModelElement(this.getLeftOperation().getModelElementId());
        return "Delete " + DecisionUtil.getClassAndName(modelElement);
    }
}

