/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.server.model.versioning.operations.impl.AbstractOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureOperationImpl
extends AbstractOperationImpl
implements FeatureOperation {
    protected static final String FEATURE_NAME_EDEFAULT = "";
    protected String featureName = "";

    @Override
    public boolean canApply(Project project) {
        if (!super.canApply(project)) {
            return false;
        }
        EObject element = project.getModelElement(this.getModelElementId());
        try {
            this.getFeature(element);
        }
        catch (UnkownFeatureException e) {
            return false;
        }
        for (ModelElementId otherElementId : this.getOtherInvolvedModelElements()) {
            if (project.contains(otherElementId)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void reverse(AbstractOperation abstractOperation) {
        super.reverse(abstractOperation);
        if (!(abstractOperation instanceof FeatureOperation)) {
            throw new IllegalArgumentException("Given operation is not a feature operation.");
        }
        FeatureOperation featureOperation = (FeatureOperation)abstractOperation;
        featureOperation.setFeatureName(this.getFeatureName());
    }

    protected FeatureOperationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return OperationsPackage.Literals.FEATURE_OPERATION;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public void setFeatureName(String newFeatureName) {
        String oldFeatureName = this.featureName;
        this.featureName = newFeatureName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldFeatureName, (Object)this.featureName));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getFeatureName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setFeatureName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setFeatureName(FEATURE_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return FEATURE_NAME_EDEFAULT == null ? this.featureName != null : !FEATURE_NAME_EDEFAULT.equals(this.featureName);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (featureName: ");
        result.append(this.featureName);
        result.append(')');
        return result.toString();
    }

    @Override
    public EStructuralFeature getFeature(Project project) throws UnkownFeatureException {
        EObject modelElement = project.getModelElement(this.getModelElementId());
        if (modelElement == null) {
            throw new IllegalArgumentException("Model Element is not in the given project");
        }
        return this.getFeature(modelElement);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getName() {
        return "Unknown Operation";
    }

    @Override
    public AbstractOperation reverse() {
        return null;
    }

    @Override
    public List<AbstractOperation> getLeafOperations() {
        ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>();
        result.add(this);
        return result;
    }

    @Override
    public EStructuralFeature getFeature(EObject modelElement) throws UnkownFeatureException {
        EList features = modelElement.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!feature.getName().equals(this.getFeatureName())) continue;
            return feature;
        }
        throw new UnkownFeatureException(modelElement.eClass(), this.getFeatureName());
    }
}

