/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.ui.provider;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.ecore.FeatureResolver;
import org.eclipse.emf.parsley.ui.provider.EClassToEStructuralFeatureAsStringsMap;

public class FeaturesProvider {
    @Inject
    private FeatureResolver featureResolver;
    private Map<EClass, List<EStructuralFeature>> eClassFeaturesCache = new HashMap<EClass, List<EStructuralFeature>>();
    protected EClassToEStructuralFeatureMap map = null;
    protected EClassToEStructuralFeatureAsStringsMap stringMap = null;

    public FeatureResolver getFeatureResolver() {
        return this.featureResolver;
    }

    public List<EStructuralFeature> getEObjectFeatures(EObject eObject) {
        if (eObject == null) {
            return Collections.emptyList();
        }
        return this.getFeatures(eObject.eClass());
    }

    public List<EStructuralFeature> getFeatures(EClass eClass) {
        if (eClass == null) {
            return Collections.emptyList();
        }
        List<EStructuralFeature> features = this.eClassFeaturesCache.get(eClass);
        if (features != null) {
            return features;
        }
        features = this.getFromMap(eClass);
        if (features != null) {
            this.eClassFeaturesCache.put(eClass, features);
            return features;
        }
        features = this.getFromStringMap(eClass);
        if (features != null) {
            this.eClassFeaturesCache.put(eClass, features);
            return features;
        }
        features = this.defaultFeatures(eClass);
        this.eClassFeaturesCache.put(eClass, features);
        return this.defaultFeatures(eClass);
    }

    protected List<EStructuralFeature> defaultFeatures(EClass eClass) {
        EList eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        Collection features = Collections2.filter((Collection)eAllStructuralFeatures, feature -> feature.isChangeable() && !feature.isDerived() && (!(feature instanceof EReference) || !((EReference)feature).isContainment()));
        return new BasicEList(features);
    }

    protected List<EStructuralFeature> getFromMap(EClass eClass) {
        if (this.map == null) {
            this.buildMapInternal();
        }
        return (List)this.map.get(eClass);
    }

    protected List<EStructuralFeature> getFromStringMap(EClass eClass) {
        List list;
        if (this.stringMap == null) {
            this.buildStringMapInternal();
        }
        if ((list = (List)this.stringMap.get(eClass.getInstanceClassName())) == null) {
            return null;
        }
        LinkedList<EStructuralFeature> result = new LinkedList<EStructuralFeature>();
        for (String featureName : list) {
            EStructuralFeature feature = this.getFeatureResolver().getFeature(eClass, featureName);
            if (feature == null) continue;
            result.add(feature);
        }
        return result;
    }

    private void buildMapInternal() {
        this.buildMap(this.getMap());
    }

    public EClassToEStructuralFeatureMap getMap() {
        if (this.map == null) {
            this.map = new EClassToEStructuralFeatureMap();
        }
        return this.map;
    }

    private void buildStringMapInternal() {
        this.buildStringMap(this.getStringMap());
    }

    public EClassToEStructuralFeatureAsStringsMap getStringMap() {
        if (this.stringMap == null) {
            this.stringMap = new EClassToEStructuralFeatureAsStringsMap();
        }
        return this.stringMap;
    }

    protected void buildMap(EClassToEStructuralFeatureMap map) {
    }

    protected void buildStringMap(EClassToEStructuralFeatureAsStringsMap stringMap) {
    }

    public void addToStringMap(EClass eClass, String ... featuresNames) {
        this.getStringMap().mapTo(eClass.getInstanceClassName(), featuresNames);
    }

    public static class EClassToEStructuralFeatureMap
    extends HashMap<EClass, List<EStructuralFeature>> {
        private static final long serialVersionUID = 670116975392207101L;

        public void mapTo(EClass eClass, EStructuralFeature ... features) {
            this.put(eClass, Lists.newArrayList((Object[])features));
        }
    }
}

