/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.tree;

import ilg.gnumcueclipse.packs.core.tree.Node;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;

public class Leaf
implements Comparable<Leaf>,
IAdaptable {
    protected String fType;
    protected Node fParent;
    protected Map<String, String> fProperties;
    protected int fPackType;
    public static int PACK_TYPE_CMSIS = 1;
    public static int PACK_TYPE_XPACK = 2;

    public Leaf(String type) {
        this.fType = type;
        this.fParent = null;
        this.fProperties = null;
        this.fPackType = 0;
    }

    public Leaf(Leaf node) {
        String description;
        String keyName;
        this.fType = node.fType;
        this.fProperties = null;
        this.fParent = null;
        this.fPackType = 0;
        String name = node.getPropertyOrNull("$NAME");
        if (name != null) {
            this.setName(name.trim());
        }
        if ((keyName = node.getPropertyOrNull("$KEY")) != null) {
            this.setKeyName(keyName.trim());
        }
        if ((description = node.getPropertyOrNull("$DESC")) != null) {
            this.setDescription(description.trim());
        }
    }

    public String getType() {
        return this.fType;
    }

    public boolean isType(String type) {
        return this.fType.equals(type);
    }

    public void setType(String type) {
        this.fType = type;
    }

    public String getName() {
        String name = this.getProperty("$NAME");
        return name;
    }

    public void setName(String name) {
        this.putProperty("$NAME", name);
    }

    public String getKeyName() {
        String name = this.getProperty("$KEY");
        return name;
    }

    public void setKeyName(String name) {
        this.putProperty("$KEY", name);
    }

    public String getDescription() {
        String description = this.getProperty("$DESC");
        return description;
    }

    public void setDescription(String description) {
        this.putProperty("$DESC", description);
    }

    public int getPackType() {
        return this.fPackType;
    }

    public void setPackType(int type) {
        this.fPackType = type;
    }

    public boolean hasChildren() {
        return false;
    }

    public Leaf getNextSibling() {
        if (this.getParent() == null) {
            return null;
        }
        List<Leaf> list = this.getParent().getChildren();
        int ix = list.indexOf(this);
        assert (ix >= 0);
        if (++ix >= list.size()) {
            return null;
        }
        return list.get(ix);
    }

    public Node getParent() {
        return this.fParent;
    }

    public void moveTo(Node parent) {
        assert (parent != null);
        if (this.fParent != null) {
            this.fParent.removeChild(this);
            this.fParent = null;
        }
        parent.addChild(this);
    }

    public boolean hasProperties() {
        return this.fProperties != null && !this.fProperties.isEmpty();
    }

    public boolean hasRelevantProperties() {
        if (!this.hasProperties()) {
            return false;
        }
        for (String key : this.fProperties.keySet()) {
            if ("$NAME".equals(key) || "$DESC".equals(key)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getProperties() {
        return this.fProperties;
    }

    public Object putProperty(String name, String value) {
        if (this.fProperties == null) {
            this.fProperties = new LinkedHashMap<String, String>();
        }
        return this.fProperties.put(name, value.trim());
    }

    public Object putNonEmptyProperty(String name, String value) {
        if (value != null && value.trim().length() > 0) {
            return this.putProperty(name, value);
        }
        return null;
    }

    public boolean hasProperty(String name) {
        if (this.fProperties == null) {
            return false;
        }
        return this.fProperties.containsKey(name);
    }

    public String getPropertyOrNull(String name) {
        if (this.fProperties == null) {
            return null;
        }
        if (!this.fProperties.containsKey(name)) {
            return null;
        }
        String value = this.fProperties.get(name);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public String getProperty(String name) {
        return this.getProperty(name, "");
    }

    public String getProperty(String name, String defaultValue) {
        String property = this.getPropertyOrNull(name);
        if (property != null) {
            return property;
        }
        return defaultValue;
    }

    public String getPropertyWithParent(String name, String defaultValue) {
        String property = this.getPropertyOrNull(name);
        if (property != null) {
            return property;
        }
        Node parent = this.getParent();
        if (parent != null) {
            return parent.getPropertyWithParent(name, defaultValue);
        }
        return defaultValue;
    }

    public Map<String, String> copyPropertiesRef(Leaf node) {
        this.fProperties = node.fProperties;
        return this.fProperties;
    }

    public void copyProperties(Leaf node) {
        if (node.hasProperties()) {
            for (String key : node.fProperties.keySet()) {
                if ("$NAME".equals(key) ? this.getPropertyOrNull("$NAME") != null : "$DESC".equals(key) && this.getPropertyOrNull("$DESC") != null) continue;
                this.putProperty(key, node.getPropertyOrNull(key));
            }
        }
    }

    public boolean isBooleanProperty(String name) {
        return String.valueOf(true).equals(this.getProperty(name));
    }

    public void setBooleanProperty(String name, boolean value) {
        this.putProperty(name, String.valueOf(value));
    }

    public String toString() {
        String str = "[" + this.getType();
        if (this.hasProperties()) {
            str = String.valueOf(str) + ": " + this.getProperties().toString();
        }
        if (this.hasChildren()) {
            str = String.valueOf(str) + ", " + ((Node)this).getChildren().size() + " kids";
        }
        str = String.valueOf(str) + "]";
        return str;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public int compareTo(Leaf comp) {
        return this.getName().compareTo(comp.getName());
    }

    public static Leaf addNewChild(Node parent, String type) {
        assert (parent != null);
        Leaf node = new Leaf(type);
        parent.addChild(node);
        return node;
    }

    public static Leaf addNewChild(Node parent, Leaf from) {
        assert (parent != null);
        Leaf node = new Leaf(from);
        parent.addChild(node);
        return node;
    }

    public static Leaf addUniqueChild(Node parent, String type, String name) {
        assert (parent != null);
        Leaf node = parent.findChild(type, name);
        if (node == null) {
            node = new Leaf(type);
            parent.addChild(node);
            node.setName(name);
        }
        return node;
    }
}

