/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.datamodel;

import ilg.gnumcueclipse.debug.gdbjtag.datamodel.SvdObjectDMNode;
import ilg.gnumcueclipse.debug.gdbjtag.datamodel.SvdUtils;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralValue;
import ilg.gnumcueclipse.packs.core.tree.Leaf;
import java.math.BigInteger;

public class SvdEnumeratedValueDMNode
extends SvdObjectDMNode {
    public SvdEnumeratedValueDMNode(Leaf node) {
        super(node);
    }

    public String getValue() {
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            return this.getNode().getProperty("value");
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            String str = this.getNode().getName();
            if ("*".equals(str)) {
                return "";
            }
            return str;
        }
        return "";
    }

    public boolean isDefault() {
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            String isDefault = this.getNode().getProperty("isDefault");
            if (isDefault.isEmpty()) {
                return false;
            }
            return "true".equalsIgnoreCase(isDefault);
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            return "*".equals(this.getNode().getName());
        }
        return false;
    }

    public boolean isMatchForValue(PeripheralValue value) {
        String val;
        BigInteger bigEnumerationValue;
        block4: {
            bigEnumerationValue = null;
            try {
                val = this.getValue();
                if (!val.isEmpty()) break block4;
                return false;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        bigEnumerationValue = SvdUtils.parseScaledNonNegativeBigInteger(val);
        if (bigEnumerationValue.equals(value.getBigValue())) {
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        String value = this.getValue();
        if (this.isDefault()) {
            value = "default";
        }
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", " + value + ", \"" + this.getDescription() + "\"]";
    }
}

