/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.ui.preferences;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.embedcdt.internal.packs.ui.Activator;
import org.eclipse.embedcdt.packs.core.data.Repos;
import org.eclipse.embedcdt.packs.ui.preferences.NewRepoDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ReposPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite fComposite;
    private Table fTable;
    private TableColumn fColumnType;
    private TableColumn fColumnName;
    private TableColumn fColumnUrl;
    private Composite fButtonsComposite;
    private String[] fButtonsNames = new String[]{AbstractCPropertyTab.ADD_STR, AbstractCPropertyTab.EDIT_STR, AbstractCPropertyTab.DEL_STR};
    private Button[] fButtons;
    private List<Map<String, Object>> fContentList;
    private Repos fRepos;

    public ReposPage() {
        this.setDescription("Add links to the sites where packages are published.");
        this.fContentList = null;
        this.fButtons = null;
        this.fRepos = Repos.getInstance();
    }

    protected Control createContents(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fComposite.setLayout((Layout)layout);
        Composite groupComposite = new Composite(this.fComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 5;
        groupComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)layoutData);
        this.initTable(groupComposite);
        this.fContentList = this.fRepos.getList();
        this.updateTableContent();
        this.initButtons(groupComposite, this.fButtonsNames, 80);
        return this.fComposite;
    }

    protected void initTable(Composite comp) {
        this.fTable = new Table(comp, 67588);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.fTable.setLayoutData((Object)layoutData);
        this.fColumnType = new TableColumn(this.fTable, 0);
        this.fColumnType.setText("Type");
        this.fColumnType.setWidth(100);
        this.fColumnType.setResizable(true);
        this.fColumnName = new TableColumn(this.fTable, 0);
        this.fColumnName.setText("Name");
        this.fColumnName.setWidth(100);
        this.fColumnName.setResizable(true);
        this.fColumnUrl = new TableColumn(this.fTable, 0);
        this.fColumnUrl.setText("URL");
        this.fColumnUrl.setWidth(350);
        this.fColumnUrl.setResizable(true);
    }

    protected void updateTableContent() {
        this.fTable.removeAll();
        if (this.fContentList != null) {
            for (Map<String, Object> map : this.fContentList) {
                TableItem item = new TableItem(this.fTable, 0);
                item.setText(this.fRepos.convertToArray(map));
            }
        }
    }

    protected void initButtons(Composite comp, String[] names, int width) {
        this.fButtonsComposite = new Composite(comp, 0);
        if (names == null || names.length == 0) {
            return;
        }
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 131072;
        this.fButtonsComposite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 0;
        this.fButtonsComposite.setLayout((Layout)layout);
        this.fButtons = new Button[names.length];
        int i = 0;
        while (i < names.length) {
            this.fButtons[i] = new Button(this.fButtonsComposite, 8);
            layoutData = new GridData();
            layoutData.verticalAlignment = 0x1000000;
            layoutData.grabExcessHorizontalSpace = false;
            layoutData.horizontalAlignment = 4;
            layoutData.minimumWidth = width;
            if (names[i] != null) {
                this.fButtons[i].setText(names[i]);
            } else {
                this.fButtons[i].setVisible(false);
                this.fButtons[i].setEnabled(false);
                layoutData.heightHint = 10;
            }
            this.fButtons[i].setLayoutData((Object)layoutData);
            this.fButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ReposPage.this.buttonPressed(event);
                }
            });
            ++i;
        }
    }

    private void buttonPressed(SelectionEvent e) {
        int i = 0;
        while (i < this.fButtons.length) {
            if (this.fButtons[i].equals(e.widget)) {
                this.buttonPressed(i);
                return;
            }
            ++i;
        }
    }

    public void buttonPressed(int index) {
        switch (index) {
            case 0: {
                this.handleAddButton();
                break;
            }
            case 1: {
                this.handleEditButton();
                break;
            }
            case 2: {
                this.handleDelButton();
            }
        }
        this.updateTableContent();
    }

    private void handleAddButton() {
        NewRepoDialog dlg = new NewRepoDialog(this.fComposite.getShell(), null);
        if (dlg.open() == 0) {
            this.fContentList.add(this.fRepos.convertToMap(dlg.getData()));
        }
    }

    private void handleEditButton() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return;
        }
        NewRepoDialog dlg = new NewRepoDialog(this.fComposite.getShell(), this.fRepos.convertToArray(this.fContentList.get(index)));
        if (dlg.open() == 0) {
            this.fContentList.set(index, this.fRepos.convertToMap(dlg.getData()));
        }
    }

    private void handleDelButton() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.fContentList.remove(index);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fContentList = this.fRepos.getDefaultList();
        this.updateTableContent();
    }

    public boolean performOk() {
        try {
            this.fRepos.putList(this.fContentList);
        }
        catch (IOException e) {
            Activator.log((Throwable)e);
        }
        return super.performOk();
    }
}

