/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.util.List;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.mrtree.ComponentsProcessor;
import org.eclipse.elk.alg.mrtree.ElkGraphImporter;
import org.eclipse.elk.alg.mrtree.MrTree;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class TreeLayoutProvider
extends AbstractLayoutProvider {
    private MrTree klayTree = new MrTree();
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        if (!((Boolean)layoutGraph.getProperty(MrTreeOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)layoutGraph).execute();
        }
        ElkGraphImporter graphImporter = new ElkGraphImporter();
        TGraph tGraph = graphImporter.importGraph(layoutGraph);
        List<TGraph> components = this.componentsProcessor.split(tGraph);
        for (TGraph comp : components) {
            this.klayTree.doLayout(comp, progressMonitor.subTask(1.0f / (float)components.size()));
        }
        tGraph = this.componentsProcessor.pack(components);
        graphImporter.applyLayout(tGraph);
    }
}

