/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodePromotionStrategy;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class NodePromotion
implements ILayoutProcessor<LGraph> {
    private LGraph masterGraph;
    private List<LNode> nodesWithIncomingEdges;
    private List<LNode> nodes;
    private List<Integer> currentWidth;
    private List<Double> currentWidthPixel;
    private int[] layers;
    private int[][] degreeDiff;
    private int maxWidth;
    private double maxWidthPixel;
    private int dummyNodeCount;
    private int maxHeight;
    private double nodeSizeAffix;
    private double dummySize;
    private NodePromotionStrategy promotionStrategy;

    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Node promotion heuristic", 1.0f);
        this.masterGraph = layeredGraph;
        this.precalculateAndSetInformation();
        this.promotionStrategy = (NodePromotionStrategy)((Object)layeredGraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY));
        int promoteUntil = (Integer)this.masterGraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_MAX_ITERATIONS);
        Function funFunction = pair -> true;
        switch (this.promotionStrategy) {
            case NIKOLOV: {
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
                break;
            }
            case NIKOLOV_PIXEL: {
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
                break;
            }
            case NIKOLOV_IMPROVED: {
                this.promotionStrategy = NodePromotionStrategy.NO_BOUNDARY;
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
                int newMaxWidth = 0;
                for (Integer martha : this.currentWidth) {
                    newMaxWidth = Math.max(newMaxWidth, martha);
                }
                if (newMaxWidth <= this.maxWidth) break;
                this.promotionStrategy = NodePromotionStrategy.NIKOLOV;
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
                break;
            }
            case NIKOLOV_IMPROVED_PIXEL: {
                this.promotionStrategy = NodePromotionStrategy.NO_BOUNDARY;
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
                double newMaxWidthPixel = 0.0;
                for (Double donna : this.currentWidthPixel) {
                    newMaxWidthPixel = Math.max(newMaxWidthPixel, donna);
                }
                if (!(newMaxWidthPixel > this.maxWidthPixel)) break;
                this.promotionStrategy = NodePromotionStrategy.NIKOLOV_PIXEL;
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
                break;
            }
            case NODECOUNT_PERCENTAGE: {
                int promoteUntilN = (int)Math.ceil((double)(this.layers.length * promoteUntil) / 100.0);
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)((Function)pair -> (Integer)pair.getSecond() < promoteUntilN));
                break;
            }
            case DUMMYNODE_PERCENTAGE: {
                int promoteUntilD = (int)Math.ceil((double)(this.dummyNodeCount * promoteUntil) / 100.0);
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)((Function)pair -> (Integer)pair.getFirst() < promoteUntilD));
                break;
            }
            default: {
                this.promotionMagic((Function<Pair<Integer, Integer>, Boolean>)funFunction);
            }
        }
        this.setNewLayering(layeredGraph);
        progressMonitor.done();
    }

    private void precalculateAndSetInformation() {
        this.nodeSizeAffix = (Double)this.masterGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        this.dummySize = (Double)this.masterGraph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.maxHeight = this.masterGraph.getLayers().size();
        int layerID = this.maxHeight - 1;
        int nodeID = 0;
        this.maxWidth = 0;
        this.maxWidthPixel = 0.0;
        this.currentWidth = Lists.newArrayList((Object[])new Integer[this.maxHeight]);
        this.currentWidthPixel = Lists.newArrayList((Object[])new Double[this.maxHeight]);
        for (Layer layer : this.masterGraph.getLayers()) {
            layer.id = layerID;
            for (LNode node : layer.getNodes()) {
                node.id = nodeID++;
            }
            --layerID;
        }
        this.layers = new int[nodeID];
        this.degreeDiff = new int[nodeID][3];
        this.nodes = Lists.newArrayList();
        this.nodesWithIncomingEdges = Lists.newArrayList();
        int dummyBaggage = 0;
        this.dummyNodeCount = 0;
        for (Layer layer : this.masterGraph) {
            layerID = layer.id;
            int incoming = 0;
            int outcoming = 0;
            int layerSize = layer.getNodes().size();
            double layerSizePixel = 0.0;
            for (LNode node : layer.getNodes()) {
                nodeID = node.id;
                this.layers[nodeID] = node.getLayer().id;
                layerSizePixel += node.getSize().y + this.nodeSizeAffix;
                int inDegree = Iterables.size(node.getIncomingEdges());
                int outDegree = Iterables.size(node.getOutgoingEdges());
                this.degreeDiff[nodeID][0] = outDegree - inDegree;
                this.degreeDiff[nodeID][1] = inDegree;
                this.degreeDiff[nodeID][2] = outDegree;
                incoming += inDegree;
                outcoming += outDegree;
                if (inDegree > 0) {
                    this.nodesWithIncomingEdges.add(node);
                }
                this.nodes.add(node);
            }
            int nodesNdummies = layerSize + (dummyBaggage -= incoming);
            this.currentWidth.set(layerID, nodesNdummies);
            this.currentWidthPixel.set(layerID, layerSizePixel += (double)dummyBaggage * this.dummySize);
            this.maxWidth = Math.max(this.maxWidth, nodesNdummies);
            this.maxWidthPixel = Math.max(this.maxWidthPixel, layerSizePixel);
            this.dummyNodeCount += dummyBaggage;
            dummyBaggage += outcoming;
        }
    }

    private void promotionMagic(Function<Pair<Integer, Integer>, Boolean> funky) {
        int promotions;
        boolean promotionFlag;
        int iterationCounter = 0;
        int reducedDummies = 0;
        int[] layeringBackup = Arrays.copyOf(this.layers, this.layers.length);
        int dummyBackup = this.dummyNodeCount;
        int heightBackup = this.maxHeight;
        ArrayList currentWidthBackup = this.currentWidth;
        ArrayList currentWidthPixelBackup = this.currentWidthPixel;
        do {
            promotions = 0;
            for (LNode node : this.nodesWithIncomingEdges) {
                Pair<Integer, Boolean> promotionPair = this.promoteNode(node);
                boolean apply = true;
                if (this.promotionStrategy == NodePromotionStrategy.NIKOLOV || this.promotionStrategy == NodePromotionStrategy.NIKOLOV_PIXEL) {
                    apply = (Boolean)promotionPair.getSecond();
                }
                if ((Integer)promotionPair.getFirst() < 0 && apply) {
                    ++promotions;
                    layeringBackup = Arrays.copyOf(this.layers, this.layers.length);
                    this.dummyNodeCount += ((Integer)promotionPair.getFirst()).intValue();
                    reducedDummies += dummyBackup - this.dummyNodeCount;
                    dummyBackup = this.dummyNodeCount + (Integer)promotionPair.getFirst();
                    heightBackup = this.maxHeight;
                    currentWidthBackup = Lists.newArrayList(this.currentWidth);
                    currentWidthPixelBackup = Lists.newArrayList(this.currentWidthPixel);
                    continue;
                }
                this.layers = Arrays.copyOf(layeringBackup, layeringBackup.length);
                this.dummyNodeCount = dummyBackup;
                this.currentWidth = Lists.newArrayList(currentWidthBackup);
                this.currentWidthPixel = Lists.newArrayList(currentWidthPixelBackup);
                this.maxHeight = heightBackup;
            }
        } while (promotionFlag = promotions != 0 && (Boolean)funky.apply((Object)Pair.of((Object)reducedDummies, (Object)(++iterationCounter))) != false);
    }

    private Pair<Integer, Boolean> promoteNode(LNode node) {
        boolean maxWidthNotExceeded = true;
        int dummydiff = 0;
        int nodeLayerPos = this.layers[node.id];
        double nodeSize = node.getSize().y + this.nodeSizeAffix;
        int dummiesBuilt = this.degreeDiff[node.id][2];
        this.currentWidth.set(nodeLayerPos, this.currentWidth.get(nodeLayerPos) - 1 + dummiesBuilt);
        this.currentWidthPixel.set(nodeLayerPos, this.currentWidthPixel.get(nodeLayerPos) - nodeSize + (double)dummiesBuilt * this.dummySize);
        if (++nodeLayerPos >= this.maxHeight) {
            ++this.maxHeight;
            this.currentWidth.add(1);
            this.currentWidthPixel.add(nodeSize);
        } else {
            int dummiesReduced = this.degreeDiff[node.id][1];
            this.currentWidth.set(nodeLayerPos, this.currentWidth.get(nodeLayerPos) + 1 - dummiesReduced);
            this.currentWidthPixel.set(nodeLayerPos, this.currentWidthPixel.get(nodeLayerPos) + nodeSize - (double)dummiesReduced * this.dummySize);
        }
        if (this.promotionStrategy == NodePromotionStrategy.NIKOLOV && (this.currentWidth.get(nodeLayerPos) > this.maxWidth || this.currentWidth.get(nodeLayerPos - 1) > this.maxWidth) || this.promotionStrategy == NodePromotionStrategy.NIKOLOV_PIXEL && (this.currentWidthPixel.get(nodeLayerPos) > this.maxWidthPixel || this.currentWidthPixel.get(nodeLayerPos - 1) > this.maxWidthPixel)) {
            maxWidthNotExceeded = false;
        }
        for (LEdge edge : node.getIncomingEdges()) {
            LNode masterNode = edge.getSource().getNode();
            if (this.layers[masterNode.id] != nodeLayerPos) continue;
            Pair<Integer, Boolean> promotion = this.promoteNode(masterNode);
            dummydiff += ((Integer)promotion.getFirst()).intValue();
            boolean bl = maxWidthNotExceeded = maxWidthNotExceeded && (Boolean)promotion.getSecond() != false;
        }
        this.layers[node.id] = nodeLayerPos;
        return new Pair((Object)(dummydiff += this.degreeDiff[node.id][0]), (Object)maxWidthNotExceeded);
    }

    private void setNewLayering(LGraph layeredGraph) {
        ArrayList layList = Lists.newArrayList();
        int i = 0;
        while (i <= this.maxHeight) {
            Layer laLaLayer = new Layer(layeredGraph);
            laLaLayer.id = this.maxHeight - i;
            layList.add(laLaLayer);
            ++i;
        }
        for (LNode node : this.nodes) {
            node.setLayer((Layer)layList.get(this.maxHeight - this.layers[node.id]));
        }
        Iterator layerIt = layList.iterator();
        while (layerIt.hasNext()) {
            Layer possiblyEvilLayer = (Layer)layerIt.next();
            if (!possiblyEvilLayer.getNodes().isEmpty()) continue;
            layerIt.remove();
        }
        layeredGraph.getLayers().clear();
        layeredGraph.getLayers().addAll(layList);
    }
}

