/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing;

import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.util.adapters.GraphAdapters;

public final class NodeMarginCalculator {
    private boolean includeLabels = true;
    private boolean includePorts = true;
    private boolean includePortLabels = true;
    private boolean includeEdgeHeadTailLabels = true;
    private GraphAdapters.GraphAdapter<?> adapter;

    protected NodeMarginCalculator(GraphAdapters.GraphAdapter<?> adapter) {
        this.adapter = adapter;
    }

    public NodeMarginCalculator excludeLabels() {
        this.includeLabels = false;
        return this;
    }

    public NodeMarginCalculator excludePorts() {
        this.includePorts = false;
        return this;
    }

    public NodeMarginCalculator excludePortLabels() {
        this.includePortLabels = false;
        return this;
    }

    public NodeMarginCalculator excludeEdgeHeadTailLabels() {
        this.includeEdgeHeadTailLabels = false;
        return this;
    }

    public void process() {
        double spacing = (Double)this.adapter.getProperty(CoreOptions.SPACING_LABEL_NODE);
        for (GraphAdapters.NodeAdapter node : this.adapter.getNodes()) {
            this.processNode(node, spacing);
        }
    }

    public void processNode(GraphAdapters.NodeAdapter<?> node) {
        double spacing = (Double)this.adapter.getProperty(CoreOptions.SPACING_LABEL_NODE);
        this.processNode(node, spacing);
    }

    private void processNode(GraphAdapters.NodeAdapter<?> node, double labelSpacing) {
        ElkRectangle boundingBox = new ElkRectangle(node.getPosition().x, node.getPosition().y, node.getSize().x, node.getSize().y);
        ElkRectangle elementBox = new ElkRectangle();
        if (this.includeLabels) {
            for (GraphAdapters.LabelAdapter label : node.getLabels()) {
                elementBox.x = label.getPosition().x + node.getPosition().x;
                elementBox.y = label.getPosition().y + node.getPosition().y;
                elementBox.width = label.getSize().x;
                elementBox.height = label.getSize().y;
                boundingBox.union(elementBox);
            }
        }
        for (GraphAdapters.PortAdapter port : node.getPorts()) {
            double portX = port.getPosition().x + node.getPosition().x;
            double portY = port.getPosition().y + node.getPosition().y;
            if (this.includePorts) {
                elementBox.x = portX;
                elementBox.y = portY;
                elementBox.width = port.getSize().x;
                elementBox.height = port.getSize().y;
                boundingBox.union(elementBox);
            }
            if (this.includePortLabels) {
                for (GraphAdapters.LabelAdapter label : port.getLabels()) {
                    elementBox.x = label.getPosition().x + portX;
                    elementBox.y = label.getPosition().y + portY;
                    elementBox.width = label.getSize().x;
                    elementBox.height = label.getSize().y;
                    boundingBox.union(elementBox);
                }
            }
            if (!this.includeEdgeHeadTailLabels) continue;
            KVector requiredPortLabelSpace = new KVector(-labelSpacing, -labelSpacing);
            if (node.getProperty(CoreOptions.PORT_LABELS_PLACEMENT) == PortLabelPlacement.OUTSIDE) {
                for (GraphAdapters.LabelAdapter label : port.getLabels()) {
                    requiredPortLabelSpace.x += label.getSize().x + labelSpacing;
                    requiredPortLabelSpace.y += label.getSize().y + labelSpacing;
                }
            }
            requiredPortLabelSpace.x = Math.max(requiredPortLabelSpace.x, 0.0);
            requiredPortLabelSpace.y = Math.max(requiredPortLabelSpace.y, 0.0);
            this.processEdgeHeadTailLabels(boundingBox, port.getOutgoingEdges(), port.getIncomingEdges(), node, port, requiredPortLabelSpace, labelSpacing);
        }
        if (this.includeEdgeHeadTailLabels) {
            this.processEdgeHeadTailLabels(boundingBox, node.getOutgoingEdges(), node.getIncomingEdges(), node, null, null, labelSpacing);
        }
        ElkMargin margin = new ElkMargin(node.getMargin());
        margin.top = node.getPosition().y - boundingBox.y;
        margin.bottom = boundingBox.y + boundingBox.height - (node.getPosition().y + node.getSize().y);
        margin.left = node.getPosition().x - boundingBox.x;
        margin.right = boundingBox.x + boundingBox.width - (node.getPosition().x + node.getSize().x);
        node.setMargin(margin);
    }

    private void processEdgeHeadTailLabels(ElkRectangle boundingBox, Iterable<GraphAdapters.EdgeAdapter<?>> outgoingEdges, Iterable<GraphAdapters.EdgeAdapter<?>> incomingEdges, GraphAdapters.NodeAdapter<?> node, GraphAdapters.PortAdapter<?> port, KVector portLabelSpace, double labelSpacing) {
        ElkRectangle labelBox = new ElkRectangle();
        for (GraphAdapters.EdgeAdapter<?> edge : outgoingEdges) {
            for (GraphAdapters.LabelAdapter label : edge.getLabels()) {
                if (label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.TAIL) continue;
                this.computeLabelBox(labelBox, label, false, node, port, portLabelSpace, labelSpacing);
                boundingBox.union(labelBox);
            }
        }
        for (GraphAdapters.EdgeAdapter<?> edge : incomingEdges) {
            for (GraphAdapters.LabelAdapter label : edge.getLabels()) {
                if (label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.HEAD) continue;
                this.computeLabelBox(labelBox, label, true, node, port, portLabelSpace, labelSpacing);
                boundingBox.union(labelBox);
            }
        }
    }

    private void computeLabelBox(ElkRectangle labelBox, GraphAdapters.LabelAdapter<?> label, boolean incomingEdge, GraphAdapters.NodeAdapter<?> node, GraphAdapters.PortAdapter<?> port, KVector portLabelSpace, double labelSpacing) {
        labelBox.x = node.getPosition().x;
        labelBox.y = node.getPosition().y;
        if (port != null) {
            labelBox.x += port.getPosition().x;
            labelBox.y += port.getPosition().y;
        }
        labelBox.width = label.getSize().x;
        labelBox.height = label.getSize().y;
        if (port == null) {
            labelBox.x = incomingEdge ? (labelBox.x -= labelSpacing + label.getSize().x) : (labelBox.x += node.getSize().x + labelSpacing);
        } else {
            switch (port.getSide()) {
                case UNDEFINED: 
                case EAST: {
                    labelBox.x += port.getSize().x + labelSpacing + portLabelSpace.x + labelSpacing;
                    break;
                }
                case WEST: {
                    labelBox.x -= labelSpacing + portLabelSpace.x + labelSpacing + label.getSize().x;
                    break;
                }
                case NORTH: {
                    labelBox.x += port.getSize().x + labelSpacing;
                    labelBox.y -= labelSpacing + portLabelSpace.y + labelSpacing + label.getSize().y;
                    break;
                }
                case SOUTH: {
                    labelBox.x += port.getSize().x + labelSpacing;
                    labelBox.y += port.getSize().y + labelSpacing + portLabelSpace.y + labelSpacing;
                }
            }
        }
    }
}

