/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.position.ISelfLoopPortPositioner;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public abstract class AbstractSelfLoopPortPositioner
implements ISelfLoopPortPositioner {
    protected static final Comparator<SelfLoopPort> ORIGINAL_INDEX_PORT_COMPARATOR = new Comparator<SelfLoopPort>(){
        private static final double EPSILON = 1.0E-10;

        @Override
        public int compare(SelfLoopPort port1, SelfLoopPort port2) {
            if (port1.getPortSide() == port2.getPortSide()) {
                PortConstraints portConstraint = (PortConstraints)port1.getLPort().getNode().getProperty(LayeredOptions.PORT_CONSTRAINTS);
                if (portConstraint == PortConstraints.FIXED_POS) {
                    KVector position1 = port1.getLPort().getPosition();
                    KVector position2 = port2.getLPort().getPosition();
                    switch (port1.getPortSide()) {
                        case NORTH: {
                            return DoubleMath.fuzzyCompare((double)position1.x, (double)position2.x, (double)1.0E-10);
                        }
                        case EAST: {
                            return -1 * DoubleMath.fuzzyCompare((double)position1.y, (double)position2.y, (double)1.0E-10);
                        }
                        case SOUTH: {
                            return -1 * DoubleMath.fuzzyCompare((double)position1.x, (double)position2.x, (double)1.0E-10);
                        }
                        case WEST: {
                            return DoubleMath.fuzzyCompare((double)position1.y, (double)position2.y, (double)1.0E-10);
                        }
                    }
                    return 0;
                }
                return Integer.compare(port1.getOriginalIndex(), port2.getOriginalIndex());
            }
            return Integer.compare(port1.getPortSide().ordinal(), port2.getPortSide().ordinal());
        }
    };
    protected static final Comparator<SelfLoopPort> INCOMING_EDGE_PORT_COMPARATOR = new Comparator<SelfLoopPort>(){

        @Override
        public int compare(SelfLoopPort port1, SelfLoopPort port2) {
            int incomingEdgesPort1 = port1.getLPort().getIncomingEdges().size();
            int incomingEdgesPort2 = port2.getLPort().getIncomingEdges().size();
            return Integer.compare(incomingEdgesPort1, incomingEdgesPort2);
        }
    };

    public void setDirection(SelfLoopPort port, int index, int portListSize) {
        SelfLoopRoutingDirection direction = SelfLoopRoutingDirection.BOTH;
        if (index == 0) {
            direction = SelfLoopRoutingDirection.RIGHT;
        } else if (index == portListSize - 1) {
            direction = SelfLoopRoutingDirection.LEFT;
        }
        port.setDirection(direction);
    }

    public void rotatePorts(SelfLoopComponent component) {
        List<SelfLoopPort> ports = component.getPorts();
        PortSide firstPortSide = ports.get(0).getPortSide();
        PortSide lastPortSide = ports.get(ports.size() - 1).getPortSide();
        while (firstPortSide != lastPortSide.left()) {
            ArrayList<SelfLoopPort> rotatedPorts = new ArrayList<SelfLoopPort>(ports.subList(1, ports.size()));
            rotatedPorts.add(ports.get(0));
            component.getPorts().clear();
            component.getPorts().addAll(rotatedPorts);
            firstPortSide = ports.get(0).getPortSide();
            lastPortSide = ports.get(ports.size() - 1).getPortSide();
        }
    }

    protected void stackComponents(SelfLoopNode slNode, Collection<SelfLoopComponent> components, PortSide side) {
        for (SelfLoopComponent component : components) {
            List<SelfLoopPort> ports = component.getPorts();
            ports.sort(INCOMING_EDGE_PORT_COMPARATOR);
            int i = 0;
            while (i < ports.size()) {
                SelfLoopPort port = ports.get(i);
                this.setDirection(port, i, ports.size());
                port.setPortSide(side);
                if (port.getLPort().getIncomingEdges().isEmpty()) {
                    slNode.prependPort(port, side);
                } else {
                    slNode.appendPort(port, side);
                }
                ++i;
            }
        }
    }

    protected void stackCornerComponents(SelfLoopNode slNode, Collection<SelfLoopComponent> cornerComponents, PortSide leftSide, PortSide rightSide) {
        for (SelfLoopComponent component : cornerComponents) {
            SelfLoopPort port;
            List<SelfLoopPort> ports = component.getPorts();
            ports.sort(INCOMING_EDGE_PORT_COMPARATOR);
            int i = 0;
            while (i < ports.size() / 2) {
                port = ports.get(i);
                slNode.appendPort(port, leftSide);
                port.setPortSide(leftSide);
                this.setDirection(port, ports.indexOf(port), ports.size());
                ++i;
            }
            i = ports.size() / 2;
            while (i < ports.size()) {
                port = ports.get(i);
                slNode.prependPort(port, rightSide);
                port.setPortSide(rightSide);
                this.setDirection(port, ports.indexOf(port), ports.size());
                ++i;
            }
        }
    }

    protected void sequenceComponents(SelfLoopNode slNode, Collection<SelfLoopComponent> components, PortSide side) {
        for (SelfLoopComponent component : components) {
            List<SelfLoopPort> ports = component.getPorts();
            ports.sort(INCOMING_EDGE_PORT_COMPARATOR);
            slNode.appendPorts(ports, PortSide.NORTH);
            for (SelfLoopPort port : ports) {
                port.setPortSide(PortSide.NORTH);
                this.setDirection(port, ports.indexOf(port), ports.size());
            }
        }
    }

    protected void placeNonLoopPorts(SelfLoopNode slNode, PortSide side, List<SelfLoopComponent> components) {
        if (side == PortSide.WEST) {
            Collections.reverse(components);
        }
        int median = (int)Math.ceil((double)components.size() / 2.0);
        List<SelfLoopComponent> firstHalf = components.subList(0, median);
        List<SelfLoopComponent> secondHalf = components.subList(median, components.size());
        for (SelfLoopComponent component : secondHalf) {
            slNode.prependPorts(component.getPorts(), side);
        }
        for (SelfLoopComponent component : firstHalf) {
            slNode.appendPorts(component.getPorts(), side);
        }
    }
}

