/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public final class SelfLoopComponentMerger {
    private static final int PORT_DISTANCE = 5;

    private SelfLoopComponentMerger() {
    }

    public static void mergeComponents(SelfLoopNode slNode) {
        LNode lNode = slNode.getNode();
        if (lNode.getProperty(InternalProperties.ORIGINAL_PORT_CONSTRAINTS) == PortConstraints.FREE) {
            KVector size;
            ArrayList<SelfLoopPort> sourcePorts = new ArrayList<SelfLoopPort>();
            ArrayList<SelfLoopPort> targetPorts = new ArrayList<SelfLoopPort>();
            SelfLoopLabel label = new SelfLoopLabel();
            int componentsWithLabels = 0;
            for (SelfLoopComponent component : slNode.getSelfLoopComponents()) {
                slNode.getNodeSide(PortSide.NORTH).getComponentDependencies().add(component);
                slNode.getNodeSide(PortSide.NORTH).setMaximumPortLevel(1);
                component.getDependencyComponents().clear();
                for (SelfLoopPort port : component.getPorts()) {
                    if (port.getLPort().getIncomingEdges().isEmpty()) {
                        targetPorts.add(port);
                    } else {
                        sourcePorts.add(port);
                    }
                    port.setMaximumLevel(1);
                    port.setPortSide(PortSide.NORTH);
                }
                SelfLoopLabel componentLabel = component.getSelfLoopLabel();
                if (componentLabel == null) continue;
                label.getLabels().addAll(componentLabel.getLabels());
                label.setHeight(label.getHeight() + componentLabel.getHeight());
                label.setWidth(Math.max(label.getWidth(), componentLabel.getWidth()));
                component.setSelfLoopLabel(null);
                ++componentsWithLabels;
            }
            if (componentsWithLabels > 0) {
                double labelLabelSpacing = LGraphUtil.getIndividualOrInherited(lNode, LayeredOptions.SPACING_LABEL_LABEL);
                double delta = Math.max(0.0, labelLabelSpacing * (double)(componentsWithLabels - 1));
                label.setHeight(label.getHeight() + delta);
            }
            slNode.getSelfLoopComponents().get(0).setSelfLoopLabel(label);
            Collections.reverse(label.getLabels());
            double nodeWidth = lNode.getSize().x;
            for (SelfLoopPort port : sourcePorts) {
                KVector source = port.getLPort().getPosition();
                size = port.getLPort().getSize();
                source.set(new KVector(nodeWidth / 2.0 + 5.0 - size.x / 2.0, -size.y));
            }
            for (SelfLoopPort port : targetPorts) {
                KVector target = port.getLPort().getPosition();
                size = port.getLPort().getSize();
                target.set(new KVector(nodeWidth / 2.0 - 5.0 - size.x / 2.0, -size.y));
            }
        }
    }
}

