/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LayerConstraintProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        Object node;
        int n;
        LNode[] lNodeArray;
        LNode[] nodes;
        monitor.begin("Layer constraint application", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        if (layers.isEmpty()) {
            monitor.done();
            return;
        }
        Layer firstLayer = layers.get(0);
        Layer lastLayer = layers.get(layers.size() - 1);
        Layer veryFirstLayer = new Layer(layeredGraph);
        Layer veryLastLayer = new Layer(layeredGraph);
        Layer firstLabelLayer = new Layer(layeredGraph);
        Layer lastLabelLayer = new Layer(layeredGraph);
        for (Layer layer : layers) {
            lNodeArray = nodes = LGraphUtil.toNodeArray(layer.getNodes());
            n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                node = lNodeArray[n2];
                LayerConstraint constraint = (LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT));
                switch (constraint) {
                    case FIRST: {
                        ((LNode)((Object)node)).setLayer(firstLayer);
                        this.throwUpUnlessNoIncomingEdges((LNode)((Object)node), true);
                        this.moveLabelsToLabelLayer((LNode)((Object)node), true, firstLabelLayer);
                        break;
                    }
                    case FIRST_SEPARATE: {
                        ((LNode)((Object)node)).setLayer(veryFirstLayer);
                        this.throwUpUnlessNoIncomingEdges((LNode)((Object)node), false);
                        break;
                    }
                    case LAST: {
                        ((LNode)((Object)node)).setLayer(lastLayer);
                        this.throwUpUnlessNoOutgoingEdges((LNode)((Object)node), true);
                        this.moveLabelsToLabelLayer((LNode)((Object)node), false, lastLabelLayer);
                        break;
                    }
                    case LAST_SEPARATE: {
                        ((LNode)((Object)node)).setLayer(veryLastLayer);
                        this.throwUpUnlessNoOutgoingEdges((LNode)((Object)node), false);
                    }
                }
                ++n2;
            }
        }
        if (layers.size() >= 2) {
            boolean moveAllowed = true;
            Layer sndFirstLayer = layers.get(1);
            for (LNode node2 : firstLayer) {
                if (node2.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.NONE) {
                    moveAllowed = false;
                    break;
                }
                for (LEdge edge : node2.getOutgoingEdges()) {
                    if (edge.getTarget().getNode().getLayer() != sndFirstLayer) continue;
                    moveAllowed = false;
                    break;
                }
                if (!moveAllowed) break;
            }
            if (moveAllowed) {
                lNodeArray = nodes = LGraphUtil.toNodeArray(firstLayer.getNodes());
                n = nodes.length;
                int edge = 0;
                while (edge < n) {
                    node = lNodeArray[edge];
                    ((LNode)((Object)node)).setLayer(sndFirstLayer);
                    ++edge;
                }
                layers.remove(firstLayer);
                firstLayer = sndFirstLayer;
            }
        }
        if (layers.size() >= 2) {
            boolean moveAllowed = true;
            Layer sndLastLayer = layers.get(layers.size() - 2);
            for (LNode node2 : lastLayer) {
                if (node2.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.NONE) {
                    moveAllowed = false;
                    break;
                }
                for (LEdge edge : node2.getIncomingEdges()) {
                    if (edge.getSource().getNode().getLayer() != sndLastLayer) continue;
                    moveAllowed = false;
                    break;
                }
                if (!moveAllowed) break;
            }
            if (moveAllowed) {
                lNodeArray = nodes = LGraphUtil.toNodeArray(lastLayer.getNodes());
                int n3 = nodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    node = lNodeArray[n4];
                    ((LNode)((Object)node)).setLayer(sndLastLayer);
                    ++n4;
                }
                layers.remove(lastLayer);
                lastLayer = sndLastLayer;
            }
        }
        if (layers.size() == 1 && layers.get(0).getNodes().isEmpty()) {
            layers.remove(0);
        }
        if (!firstLabelLayer.getNodes().isEmpty()) {
            layers.add(0, firstLabelLayer);
        }
        if (!veryFirstLayer.getNodes().isEmpty()) {
            layers.add(0, veryFirstLayer);
        }
        if (!lastLabelLayer.getNodes().isEmpty()) {
            layers.add(lastLabelLayer);
        }
        if (!veryLastLayer.getNodes().isEmpty()) {
            layers.add(veryLastLayer);
        }
        monitor.done();
    }

    private void moveLabelsToLabelLayer(LNode node, boolean incoming, Layer labelLayer) {
        for (LEdge edge : incoming ? node.getIncomingEdges() : node.getOutgoingEdges()) {
            LNode possibleLableDummy;
            LNode lNode = possibleLableDummy = incoming ? edge.getSource().getNode() : edge.getTarget().getNode();
            if (possibleLableDummy.getType() != LNode.NodeType.LABEL) continue;
            possibleLableDummy.setLayer(labelLayer);
        }
    }

    private void throwUpUnlessNoIncomingEdges(LNode node, boolean allowFromFirstSeparate) {
        for (LPort port : node.getPorts()) {
            for (LEdge incoming : port.getIncomingEdges()) {
                if (this.isAcceptableIncomingEdge(incoming)) continue;
                if (allowFromFirstSeparate) {
                    throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to FIRST, but has at least one incoming edge that " + " does not come from a FIRST_SEPARATE node. That must not happen.");
                }
                throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to FIRST_SEPARATE, but has at least one incoming " + "edge. FIRST_SEPARATE nodes must not have incoming edges.");
            }
        }
    }

    private boolean isAcceptableIncomingEdge(LEdge edge) {
        LNode sourceNode = edge.getSource().getNode();
        LNode targetNode = edge.getTarget().getNode();
        if (sourceNode.getType() == LNode.NodeType.EXTERNAL_PORT && targetNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            return true;
        }
        assert (targetNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST);
        if (sourceNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST_SEPARATE) {
            return true;
        }
        return sourceNode.getType() == LNode.NodeType.LABEL;
    }

    private void throwUpUnlessNoOutgoingEdges(LNode node, boolean allowToLastSeparate) {
        for (LPort port : node.getPorts()) {
            for (LEdge outgoing : port.getOutgoingEdges()) {
                if (this.isAcceptableOutgoingEdge(outgoing)) continue;
                if (allowToLastSeparate) {
                    throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to LAST, but has at least one outgoing edge that " + " does not go to a LAST_SEPARATE node. That must not happen.");
                }
                throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to LAST_SEPARATE, but has at least one outgoing " + "edge. LAST_SEPARATE nodes must not have outgoing edges.");
            }
        }
    }

    private boolean isAcceptableOutgoingEdge(LEdge edge) {
        LNode sourceNode = edge.getSource().getNode();
        LNode targetNode = edge.getTarget().getNode();
        if (sourceNode.getType() == LNode.NodeType.EXTERNAL_PORT && targetNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            return true;
        }
        assert (sourceNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST);
        if (targetNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE) {
            return true;
        }
        return targetNode.getType() == LNode.NodeType.LABEL;
    }
}

